% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.json.R
\name{as.json}
\alias{as.json}
\title{Convert inputs to JSON}
\usage{
as.json(x, ...)
}
\arguments{
\item{x}{Input}

\item{...}{Further args passed on to \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}}
}
\description{
Convert inputs to JSON
}
\details{
when the output of \code{\link[=topojson_list]{topojson_list()}} is given to
this function we use a special internal fxn \code{astjl()} to
parse the object - see that fxn and let us know if any
problems you run in to
}
\examples{
\dontrun{
(res <- geojson_list(us_cities[1:2,], lat='lat', lon='long'))
as.json(res)
as.json(res, pretty = TRUE)

vec <- c(-99.74,32.45)
as.json(geojson_list(vec))
as.json(geojson_list(vec), pretty = TRUE)
}
}
