% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_urban_area.R
\name{read_urban_area}
\alias{read_urban_area}
\title{Download spatial data of urbanized areas in Brazil}
\usage{
read_urban_area(
  year = 2015,
  code_state = "all",
  simplified = TRUE,
  showProgress = TRUE
)
}
\arguments{
\item{year}{Numeric. Year of the data in YYYY format. Defaults to \code{2015}.}

\item{code_state}{The two-digit code of a state or a two-letter uppercase
abbreviation (e.g. 33 or "RJ"). If \code{code_state="all"} (the
default), the function downloads all states.}

\item{simplified}{Logic \code{FALSE} or \code{TRUE}, indicating whether the function
should return the data set with 'original' spatial resolution or a data set
with 'simplified' geometry. Defaults to \code{TRUE}. For spatial analysis and
statistics users should set \code{simplified = FALSE}. Borders have been
simplified by removing vertices of borders using \verb{st_simplify\{sf\}} preserving
topology with a \code{dTolerance} of 100.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar.}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
This function reads the official data on the urban footprint of Brazilian cities
in the years 2005 and 2015. Original data were generated by the Institute of Geography
and Statistics (IBGE)  For more information about the methodology, see details at
\url{https://biblioteca.ibge.gov.br/visualizacao/livros/liv100639.pdf}
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Read urban footprint of Brazilian cities in an specific year
d <- read_urban_area(year=2005)
\dontshow{\}) # examplesIf}
}
\seealso{
Other area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_capitals}()},
\code{\link{read_comparable_areas}()},
\code{\link{read_country}()},
\code{\link{read_disaster_risk_area}()},
\code{\link{read_health_facilities}()},
\code{\link{read_health_region}()},
\code{\link{read_immediate_region}()},
\code{\link{read_indigenous_land}()},
\code{\link{read_intermediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_metro_area}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipal_seat}()},
\code{\link{read_municipality}()},
\code{\link{read_neighborhood}()},
\code{\link{read_pop_arrangements}()},
\code{\link{read_region}()},
\code{\link{read_schools}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_statistical_grid}()},
\code{\link{read_urban_concentrations}()},
\code{\link{read_weighting_area}()}
}
\concept{area functions}
