% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cep_to_state.R
\name{cep_to_state}
\alias{cep_to_state}
\title{Determine the state of a given CEP postal code}
\usage{
cep_to_state(cep)
}
\arguments{
\item{cep}{A numeric string with 8 digits in the format \code{xxxxxxxx}, or a
character with the format \code{'xxxxx-xxx'}.}
}
\value{
A character string with a state abbreviation
}
\description{
Zips codes in Brazil are known as CEP, the abbreviation for postal code address.
CEPs in Brazil are 8 digits long, with the format \code{'xxxxx-xxx'}.
}
\examples{
\donttest{
uf <- cep_to_state(cep = '69900-000')

# Or:
uf <- cep_to_state(cep = 69900000)
}

}
