% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_municipal_seat.R
\name{read_municipal_seat}
\alias{read_municipal_seat}
\title{Download official data of municipal seats (sede dos municipios) in Brazil as an sf object.}
\usage{
read_municipal_seat(year = NULL)
}
\arguments{
\item{year}{A year number in YYYY format (Defaults to 2010)}
}
\description{
This function reads the official data on the municipal seats (sede dos municipios) of Brazil.
The data brings the spatial coordinates (lat lon) of of municipal seats for various years
between 1872 and 2010. Orignal data were generated by Brazilian Institute of Geography
and Statistics (IBGE).
}
\examples{
\donttest{

library(geobr)

# Read municipal seats in an specific year
  m <- read_municipal_seat(year=1991)

}


}
