% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gensvm.accuracy.R
\name{gensvm.accuracy}
\alias{gensvm.accuracy}
\title{Compute the accuracy score}
\usage{
gensvm.accuracy(y.true, y.pred)
}
\arguments{
\item{y.true}{vector of true labels}

\item{y.pred}{vector of predicted labels}
}
\value{
The accuracy as a value in the range [0.0, 1.0]
}
\description{
Compute the accuracy score between the true labels and the 
predicted labels.
}
\examples{
x <- iris[, -5]
y <- iris[, 5]

fit <- gensvm(x, y)
gensvm.accuracy(predict(fit, x), y)

}
\references{
Van den Burg, G.J.J. and Groenen, P.J.F. (2016). \emph{GenSVM: A Generalized 
Multiclass Support Vector Machine}, Journal of Machine Learning Research, 
17(225):1--42. URL \url{http://jmlr.org/papers/v17/14-526.html}.
}
\seealso{
\code{\link{predict.gensvm.grid}}, \code{\link{predict.gensvm}}, 
\code{\link{gensvm-package}}
}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen \cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
