% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_files_plink.R
\name{delete_files_plink}
\alias{delete_files_plink}
\title{Delete all plink binary files}
\usage{
delete_files_plink(file)
}
\arguments{
\item{file}{The shared file path (excluding BED/BIM/FAM extensions).}
}
\value{
Nothing
}
\description{
This function deletes each of the plink binary files (BED/BIM/FAM extensions) given the shared base file path, warning with an informative message if any of the files did not exist.
}
\examples{
# create dummy BED/BIM/FAM files
file <- tempfile('delete-me-test') # no extension
# add each extension and create empty files
file.create( paste0(file, '.bed') )
file.create( paste0(file, '.bim') )
file.create( paste0(file, '.fam') )

# delete the BED/BIM/FAM files we just created
delete_files_plink(file)

}
