% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO.R
\name{import_hap}
\alias{import_hap}
\title{Import hapResult/hapSummary}
\usage{
import_hap(file, type = "auto", ...)
}
\arguments{
\item{file}{hapSummary or hapResult file path.}

\item{type}{the content type of imported file, should be one of c("hapResult", "hapSummary")}

\item{...}{extras will pass to \code{read.delim()}}
}
\value{
hapSummary or hapResult
}
\description{
This function could be used for import hap result or hap summary result.
The type of returned object is decided by input file, see details.
}
\details{
The hap result and hap summary result have common features.
The common features of these two types are:
First four rows contains extra information: CHR, POS, INFO and ALLELE
Hap names were in the first column.
The differences are:
Hap summary result have a freq column while hap result not.
Rows represent haplotypes in hap summary result, while rows represent accessions in hap result.
In addtion, the accessions of each haplotype in hap summary result were separated by ";".
}
\examples{

oldDir <- getwd()
temp_dir <- tempdir()
if(! dir.exists(temp_dir))
  dir.create(temp_dir)
setwd(temp_dir)
data("geneHapR_test")
write.hap(hapResult, file = "test.pheno.txt", sep = "\t")
hap <- import_hap("test.pheno.txt")
hap
setwd(oldDir)

}
