% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionalSites.R
\name{siteEFF}
\alias{siteEFF}
\title{Calculation of Sites Effective}
\usage{
siteEFF(hap, pheno, phenoNames, quality = FALSE, method = "auto",
        p.adj = "none")
}
\arguments{
\item{hap}{object of "hapResult" class}

\item{pheno}{phenotype data, with column names as pheno name
and row name as accessions.}

\item{phenoNames}{pheno names used for analysis, if missing,
will use all pheno names in \code{pheno}}

\item{quality}{bool type, indicate whther the type of phenos are quality or
quantitative. Length of \code{quality} could be 1 or equal with length of
\code{phenoNames}. Default as \code{FALSE}}

\item{method}{character or character vector with length equal with
\code{phenoNames} indicate which method should be performed towards each
phenotype. Should be one of "t.test", "chi.test", "wilcox.test" and "auto".
Default as "auto", see details.}

\item{p.adj}{character, indicate correction method.
Could be "BH", "BY", "none"}
}
\value{
a list containing two matrix names as "p" and "EFF",
with column name are pheno names and row name are site position.
The matrix names as "p" contains all \emph{p}-value.
The matrix named as "EFF" contains scaled difference between each geno-types
per site.
}
\description{
Calculation of Sites Effective
}
\details{
The site \strong{EFF} was determinate by the phenotype difference between each
site geno-type.

The \emph{p} was calculated with statistical analysis method as designated by the
parameter \code{method}. If \code{method} set as "auto", then
chi.test will be
selected for quantity phenotype, eg.: color;
for quantity phynotype, eg.: height, with at least 30 observations per
geno-type and fit Gaussian distribution t.test will be performed, otherwise
wilcox.test will be performed.
}
\examples{
\donttest{
data("geneHapR_test")

# calculate site functional effect
siteEFF <- siteEFF(hapResult, pheno, names(pheno))
plotEFF(siteEFF, gff = gff, Chr = "scaffold_1")
}
}
