% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/genderizeAPI.R
\name{genderizeAPI}
\alias{genderizeAPI}
\title{Getting data from genderize.io  API}
\usage{
genderizeAPI(x)
}
\arguments{
\item{x}{A vector of terms to check in genderize.io database.}
}
\value{
A data frame with names' gener probabilities and counts. NULL if a given name is not located in the genderize.io database.
}
\description{
\code{genderizeAPI} connects with genderize.io API and checks if
a term (one or more) is in the given names database and returns
its gender probability and count.
}
\examples{
\dontrun{

x = c("Winston J. Durant, ASHP past president, dies at 84",
"Gold Badge of Honour of the DGAI Prof. Dr. med. Norbert R. Roewer Wuerzburg",
"The contribution of professor Yu.S. Martynov (1921-2008) to Russian neurology",
"JAN BASZKIEWICZ (3 JANUARY 1930 - 27 JANUARY 2011) IN MEMORIAM",
"Maria Sklodowska-Curie")

terms= textPrepare(x)
terms
genderizeAPI(terms)

}
}

