% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{ggplotDistanceGraph}
\alias{ggplotDistanceGraph}
\title{Plotting a Distance Network}
\usage{
ggplotDistanceGraph(BC_dat, minDist = 1, loga = TRUE, ori_BCs = NULL,
  lay = "fruchtermanreingold", complete = FALSE,
  col_type = "rainbow", outline = 0.1, m = "hamming",
  scale_nodes = 1, scale_edges = 1, legend_size = 4)
}
\arguments{
\item{BC_dat}{a BCdat object.}

\item{minDist}{an integer value representing the maximal distance for which the graph will
contain edges.}

\item{loga}{a logical value, indicating the use or non-use of logarithmic read count values.}

\item{ori_BCs}{a vector of character strings containing the barcode sequences (without the fixed positions of the barcode construct).}

\item{lay}{a character string, identifying the prefered layout algorithm (see ggnetwork layout option).}

\item{complete}{a logical value. If TRUE, every node will have at least one edge.}

\item{col_type}{a character sting, choosing one of the available color palettes.}

\item{outline}{a nnumeric value which adjusts the thickness of the black outline of each node.}

\item{m}{a character string, Method for distance calculation, default value is Hamming distance. Possible values
are "osa", "lv", "dl", "hamming", "lcs", "qgram", "cosine", "jaccard", "jw", "soundex" (see stringdist function
of the stringdist-package for more information).}

\item{scale_nodes}{a numeric value, scaling the node size.}

\item{scale_edges}{a numeric value, scaling the edge size.}

\item{legend_size}{a numeric value, scaling the legend symbol size, if legend_size equals 0, the legend will be dismissed.}
}
\value{
a ggplot2 object
}
\description{
ggplotDistanceGraph will create a graph-like visualisation (ripple plot) of the corresponding barcode sequences
and their similarity based on the ggplot2 and the ggnetwork packages. The nodes represent the barcode sequences and their
respective size reflects the corresponding read counts. Edges between nodes indicate a distance between two barcodes
of maximal \code{minDist}.
If \code{ori_BCs} is provided the node color also refelects the distance of a particular barcode to one of the initial
barcodes.
}
\examples{

\dontrun{

data(BC_dat)
ggplotDistanceGraph(BC_dat, minDist = 1, loga = TRUE, ori_BCs = NULL, lay = "fruchtermanreingold",
complete = FALSE, col_type = "rainbow")

}

}
