/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.ArgumentMaker;
import gov.lanl.yadas.BasicMCMCBond;
import gov.lanl.yadas.Likelihood;
import gov.lanl.yadas.MCMCBond;
import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.MixtureBond;
import gov.lanl.yadas.Poisson;
import gov.lanl.yadas.ProbConverterArgument;
import gov.lanl.yadas.ReliableSystem;
import gov.lanl.yadas.ShortConstantArgument;
import gov.lanl.yadas.ShortScaledArgument;
import gov.lanl.yadas.SystemRateArgument;
import java.util.ArrayList;

public class SystemPoissonBonds {
    ReliableSystem system;
    MCMCParameter lambda;
    MCMCParameter pi;
    double[] x;
    double[] timeOnTest;
    ArrayList bondlist = new ArrayList();

    public SystemPoissonBonds(ReliableSystem system, MCMCParameter[] params, double[] x, double[] timeOnTest) {
        this.system = system;
        this.x = x;
        this.timeOnTest = timeOnTest;
        this.lambda = params[0];
        this.pi = params[1];
        double[] piv = this.pi.getValue();
        for (int i = 0; i < system.getSize(); ++i) {
            if (!(timeOnTest[i] > 0.0)) continue;
            if (piv[i] > 0.0 && piv[i] < 1.0 || !this.pi.areConstant(i)) {
                this.bondlist.add(new MixtureBond(new MCMCParameter[][]{{this.lambda, this.pi}, {this.lambda, this.pi}}, new ArgumentMaker[][]{{new ShortConstantArgument(x, i), new ShortScaledArgument(timeOnTest, 0, i)}, {new ShortConstantArgument(x, i), new SystemRateArgument(system, timeOnTest, i)}}, new Likelihood[]{new Poisson(), new Poisson()}, new ProbConverterArgument(1, i)));
            } else if (piv[i] == 1.0) {
                this.bondlist.add(new BasicMCMCBond(new MCMCParameter[]{this.lambda, this.pi}, new ArgumentMaker[]{new ShortConstantArgument(x, i), new SystemRateArgument(system, timeOnTest, i)}, new Poisson()));
            } else if (piv[i] == 0.0) {
                this.bondlist.add(new BasicMCMCBond(new MCMCParameter[]{this.lambda, this.pi}, new ArgumentMaker[]{new ShortConstantArgument(x, i), new ShortScaledArgument(timeOnTest, 0, i)}, new Poisson()));
            }
            ((MCMCBond)this.bondlist.get(this.bondlist.size() - 1)).setName("SystemPoissonBond." + i);
        }
    }

    public ArrayList getList() {
        return this.bondlist;
    }
}

