/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.summary;

import java.util.List;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.drugis.common.beans.AbstractObservable;
import org.drugis.mtc.MCMCResults;
import org.drugis.mtc.MCMCResultsEvent;
import org.drugis.mtc.MCMCResultsListener;
import org.drugis.mtc.Parameter;
import org.drugis.mtc.summary.Summary;
import org.drugis.mtc.summary.SummaryUtil;

public class QuantileSummary
extends AbstractObservable
implements MCMCResultsListener,
Summary {
    private static final double[] DEFAULT_PROBABILITIES = new double[]{0.025, 0.5, 0.975};
    private double[] d_probabilities;
    private Parameter d_parameter;
    private MCMCResults d_results;
    private double[] d_quantiles;
    private boolean d_defined = false;

    public QuantileSummary(MCMCResults results, Parameter parameter, double[] probabilities) {
        this.d_probabilities = probabilities;
        this.d_results = results;
        this.d_parameter = parameter;
        this.d_results.addResultsListener(this);
        this.calculateResults();
    }

    public QuantileSummary(double[] probabilities, double[] quantiles) {
        int length = probabilities.length;
        this.d_probabilities = new double[length];
        this.d_quantiles = new double[length];
        System.arraycopy(probabilities, 0, this.d_probabilities, 0, length);
        System.arraycopy(quantiles, 0, this.d_quantiles, 0, length);
        this.d_defined = true;
    }

    public QuantileSummary(MCMCResults results, Parameter parameter) {
        this(results, parameter, DEFAULT_PROBABILITIES);
    }

    public void resultsEvent(MCMCResultsEvent event) {
        this.calculateResults();
    }

    public int indexOf(double p) {
        for (int i = 0; i < this.d_probabilities.length; ++i) {
            if (this.d_probabilities[i] != p) continue;
            return i;
        }
        return -1;
    }

    public double getProbability(int idx) {
        return this.d_probabilities[idx];
    }

    public double getQuantile(int idx) {
        return this.d_quantiles[idx];
    }

    public int getSize() {
        return this.d_quantiles == null ? 0 : this.d_quantiles.length;
    }

    private double calculateQuantile(int i, Percentile q) {
        double p = this.getProbability(i);
        return q.evaluate(p * 100.0);
    }

    private Percentile getSamples() {
        List<Double> list = SummaryUtil.getAllChainsLastHalfSamples(this.d_results, this.d_parameter);
        double[] arr = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = list.get(i);
        }
        Percentile percentile = new Percentile();
        percentile.setData(arr);
        return percentile;
    }

    private synchronized void calculateResults() {
        if (!this.isReady()) {
            return;
        }
        Percentile samples = this.getSamples();
        this.d_quantiles = new double[this.d_probabilities.length];
        for (int i = 0; i < this.d_quantiles.length; ++i) {
            this.d_quantiles[i] = this.calculateQuantile(i, samples);
        }
        this.d_defined = true;
        this.firePropertyChange("defined", null, this.d_defined);
    }

    private boolean isReady() {
        return this.d_results.getNumberOfSamples() > 0;
    }

    public boolean getDefined() {
        return this.d_defined;
    }
}

