/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import edu.uci.ics.jung.algorithms.transformation.FoldingTransformerFixed;
import edu.uci.ics.jung.graph.UndirectedGraph;
import org.apache.commons.math3.random.RandomGenerator;
import org.drugis.common.stat.EstimateWithPrecision;
import org.drugis.common.stat.Statistics;
import org.drugis.mtc.model.Measurement;
import org.drugis.mtc.model.Network;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.AbstractDataStartingValueGenerator;
import org.drugis.mtc.parameterization.BasicParameter;
import org.drugis.mtc.parameterization.NetworkModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuousDataStartingValueGenerator
extends AbstractDataStartingValueGenerator {
    public ContinuousDataStartingValueGenerator(Network network, UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph) {
        super(network, cGraph, null, 0.0);
    }

    public ContinuousDataStartingValueGenerator(Network network, UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph, RandomGenerator rng, double scale) {
        super(network, cGraph, rng, scale);
    }

    @Override
    protected EstimateWithPrecision estimateRelativeEffect(Study study, BasicParameter p) {
        Measurement m0 = NetworkModel.findMeasurement(study, p.getBaseline());
        Measurement m1 = NetworkModel.findMeasurement(study, p.getSubject());
        return Statistics.meanDifference(m0.getMean(), m0.getStdDev(), m0.getSampleSize().intValue(), m1.getMean(), m1.getStdDev(), m1.getSampleSize().intValue());
    }

    @Override
    protected EstimateWithPrecision estimateTreatmentEffect(Study study, Treatment treatment) {
        Measurement m = NetworkModel.findMeasurement(study, treatment);
        return new EstimateWithPrecision(m.getMean(), m.getStdDev() / Math.sqrt(m.getSampleSize().intValue()));
    }
}

