/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.list;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.collection.TransformedCollection;
import org.apache.commons.collections15.iterators.AbstractListIteratorDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedList<I, O>
extends TransformedCollection<I, O>
implements List {
    private static final long serialVersionUID = 1077193035000013141L;

    public static <I, O> List<O> decorate(List<I> list, Transformer<? super I, ? extends O> transformer) {
        return new TransformedList<I, O>(list, transformer);
    }

    protected TransformedList(List<I> list, Transformer<? super I, ? extends O> transformer) {
        super(list, transformer);
    }

    protected List<O> getList() {
        return (List)this.collection;
    }

    public O get(int index) {
        return this.getList().get(index);
    }

    @Override
    public int indexOf(Object object) {
        return this.getList().indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getList().lastIndexOf(object);
    }

    public Object remove(int index) {
        return this.getList().remove(index);
    }

    public void add(int index, Object object) {
        Object transformed = this.transform(object);
        this.getList().add(index, transformed);
    }

    public void addTyped(int index, I object) {
        this.add(index, object);
    }

    public boolean addAll(int index, Collection coll) {
        Collection transformed = this.transform(coll);
        return this.getList().addAll(index, transformed);
    }

    public ListIterator<O> listIterator() {
        return this.listIterator(0);
    }

    public ListIterator<O> listIterator(int i) {
        return new TransformedListIterator(this.getList().listIterator(i));
    }

    public O set(int index, Object object) {
        Object transformed = this.transform(object);
        return this.getList().set(index, transformed);
    }

    public O setTyped(int index, I object) {
        return this.set(index, object);
    }

    public List<O> subList(int fromIndex, int toIndex) {
        List<O> sub = this.getList().subList(fromIndex, toIndex);
        return new TransformedList<O, O>(sub, this.transformer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TransformedListIterator
    extends AbstractListIteratorDecorator {
        protected TransformedListIterator(ListIterator<O> iterator) {
            super(iterator);
        }

        @Override
        public void add(Object object) {
            Object transformed = TransformedList.this.transform(object);
            this.iterator.add(transformed);
        }

        @Override
        public void set(Object object) {
            Object transformed = TransformedList.this.transform(object);
            this.iterator.set(transformed);
        }
    }
}

