% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{validate_params}
\alias{validate_params}
\title{Validate Parameters}
\usage{
validate_params(params)
}
\arguments{
\item{params}{[mandatory] (list) A list of parameters to be validated.}
}
\value{
Returns \code{NULL} invisibly if all validations pass.
}
\description{
Validates multiple parameters.
}
\details{
The following validations are performed:
- 'admin_lvl': Ensures it is \code{NULL}, \code{0}, or \code{1}.
- 'conda': Verifies if it is an available Conda environment.
- 'file_path': Constructs a file path and checks if the file exists.
- 'keys': Ensures it is a non-empty list with valid entries.
- 'limit': Ensures it is a positive numeric value.
- 'mode': Ensures it is 'local' or 'drive'.
- 'new_values': Ensures it is a list with the same length as 'keys'.
- 'user': Verifies it is \code{NULL} or a character value.
- 'path': Verifies if the directory exists.
- 'rebuild': Verifies it is a logical value.
- 'regions': Ensures the first two characters are letters.
- 'start': Ensures it is a valid date.
- 'verbose': Verifies it is a logical value.
}
\keyword{internal}
