% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isp.R
\name{isp}
\alias{isp}
\title{interpretable stratified power(ISP) model}
\usage{
isp(
  formula,
  data,
  discvar = NULL,
  discnum = 3:8,
  overlay = "and",
  strategy = 2L,
  increase_rate = 0.05,
  minsize = 1,
  cores = 1,
  alpha = 0.95
)
}
\arguments{
\item{formula}{A formula of ISP model.}

\item{data}{A \code{data.frame}, \code{tibble} or \code{sf} object of observation data.}

\item{discvar}{(optional) Name of continuous variable columns that need to be discretized. Noted that
when \code{formula} has \code{discvar}, \code{data} must have these columns. By default, all independent variables are
used as \code{discvar}.}

\item{discnum}{A numeric vector of discretized classes of columns that need to be discretized.
Default all \code{discvar} use \code{3:8}.}

\item{overlay}{(optional) Spatial overlay method. One of \code{and}, \code{or}, \code{intersection}.
Default is \code{and}.}

\item{strategy}{(optional) Optimal discretization strategy. When \code{strategy} is \code{1L}, choose the highest q-statistics to
determinate optimal spatial data discretization parameters. When \code{strategy} is \code{2L}, The optimal discrete parameters of
spatial data are selected by combining LOESS model.}

\item{increase_rate}{(optional) The critical increase rate of the number of discretization. Default is \verb{5\%}.}

\item{minsize}{(optional) The min size of each discretization group. Default all use \code{1}.}

\item{cores}{(optional) Positive integer (default is 1). When cores are greater than 1, use
multi-core parallel computing.}

\item{alpha}{(optional) Specifies the size of confidence level. Default is \code{0.95}.}
}
\value{
A list.
\describe{
\item{\code{factor}}{factor detect results}
\item{\code{interaction}}{interaction detect results}
\item{\code{optdisc}}{independent variable optimal spatial discretization}
\item{\code{risk1}}{whether values of the response variable between a pair of overlay zones are significantly different}
\item{\code{risk2}}{risk detection result of the input data}
\item{\code{rpd}}{robust power of determinants}
\item{\code{spd}}{shap power of determinants}
\item{\code{determination}}{determination of the optimal interaction of variables}
\item{\code{number_individual_explanatory_variables}}{the number of individual explanatory variables used for examining the interaction effects}
\item{\code{number_overlay_zones}}{the number of overlay zones}
\item{\code{percentage_finely_divided_zones}}{the percentage of finely divided zones that are determined by the interaction of variables}
}
}
\description{
Function for interpretable stratified power model.
}
\note{
Please set up python dependence and configure \code{GDVERSE_PYTHON} environment variable if you want to run \code{rgd()}.
See \code{vignette('rgdrid',package = 'gdverse')} for more details.
}
\examples{
\dontrun{
## The following code needs to configure the Python environment to run:
data('sim')
sim1 = dplyr::select(sim,-dplyr::any_of(c('lo','la')))
g = isp(y ~ ., data = sim1, discnum = 3:8, cores = 6)
g
}
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
