% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{gdalcubes_start_server}
\alias{gdalcubes_start_server}
\title{Start one or more gdalcubes_server background processes}
\usage{
gdalcubes_start_server(port = 1111, endpoint = "/gdalcubes/api",
  whitelist = NULL, threads = 1, n = 1)
}
\arguments{
\item{port}{port number(s) where gdalcubes server(s) will listen for incoming requests}

\item{endpoint}{base path where the API sets up its endpoints}

\item{whitelist}{character vector with hosts that are allowed to connect to the server, if NULL (the default), all incoming requests will be accepted}

\item{threads}{number of threads running to process parallel chunk read requests}

\item{n}{number of servers to start, if n > 1 and ports has length 1, port numbers will be increased automatically by one}
}
\description{
Starts one or more gdalcubes_server instance on this machine. Created processes are added to a global list of gdalcubes_server processes.
Simultaneously running processes must use different ports.
}
\note{
This function runs the gdalcubes_server executable which must have been installed at a findable location (listed in the PATH environment variable) before.
}
\examples{
\dontrun{
 gdalcubes_start_server() # single server process with default settings
 gdalcubes_stop_server()
}
}
