% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gbfs.R
\name{get_gbfs}
\alias{get_gbfs}
\title{Save gbfs feeds.}
\usage{
get_gbfs(city, feeds = "all", directory)
}
\arguments{
\item{city}{A character string or a url to an active gbfs.json feed.}

\item{feeds}{A character string specifying which feeds should be saved. Options are
"all", "static", and "dynamic".}

\item{directory}{The name of an existing folder or folder to be created, where the feeds
will be saved.}
}
\value{
A folder containing the specified feeds saved as .rds objects.
}
\description{
\code{get_gbfs} checks for the existence of gbfs feeds for a given city and saves the
feeds as .rds objects in a directory that can be specified by the user. Go to 
`https://github.com/NABSA/gbfs/blob/master/gbfs.md` to see metadata for each dataset.
}
\examples{
\donttest{get_gbfs(city = "boise", directory = tempdir())}
\donttest{get_gbfs(city = "http://biketownpdx.socialbicycles.com/opendata/gbfs.json", 
feeds = "dynamic",  directory = tempdir())}
\donttest{get_gbfs("https://gbfs.bcycle.com/bcycle_greenbikeslc/gbfs.json", 
directory = tempdir())}
}
