% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSNR.R
\name{PSNR}
\alias{PSNR}
\title{Peak Signal to Noise Ratio.}
\usage{
PSNR(x, y)
}
\arguments{
\item{x}{Original reference signal/image.}

\item{y}{Restored or noisy signal/image.}
}
\value{
Peak Signal to Noise ratio.
}
\description{
Compute the Peack Signal to Noise Ratio, defined by:
\deqn{PSNR(x,y)=10 \log_{10}( \max(\max(x),\max(y))^2 / |x-y|^2 )}{PSNR(x,y)=10*log10( max(max(x),max(y))^2 / |x-y|^2 )}
}
\examples{
x <- cos(seq(0, 10, length=100))
y <- x + rnorm(100, sd=0.5)
PSNR(x, y)
}
