% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_wrappers.R
\name{wrappers_optim}
\alias{wrappers_optim}
\alias{wrapper_optim_stats}
\alias{wrapper_optim_nloptr}
\title{Wrappers for Optimization Functions}
\usage{
wrapper_optim_stats(obj_fun, theta_start, theta_bound_lower, theta_bound_upper,
  ...)

wrapper_optim_nloptr(obj_fun, theta_start, theta_bound_lower,
  theta_bound_upper, ...)
}
\arguments{
\item{obj_fun}{An objective function.}

\item{theta_start}{A numeric vector of starting values of the variables.}

\item{theta_bound_lower}{A numeric vector of lower bounds on the variables.}

\item{theta_bound_upper}{A numeric vector of upper bounds on the variables.}

\item{...}{Additional arguments to be passed to the optimization function. These include arguments required by the objective function, namely \code{est_details} and \code{print_progress}.}
}
\value{
A list with components:
  \item{status_optim}{The status of the optimization computation.}
  \item{theta_optim}{The optimal solution.}
}
\description{
Wrappers of common R optimization functions.
Their purpose is to be passed as the \code{optim_function} argument in the \code{\link[gasmodel:gas]{gas()}} function.
}
\section{Functions}{
\itemize{
\item \code{wrapper_optim_stats()}: Wrapper for optimization function \code{\link[stats:optim]{stats::optim()}}.

\item \code{wrapper_optim_nloptr()}: Wrapper for optimization function \code{\link[nloptr:nloptr]{nloptr::nloptr()}}.

}}
\seealso{
\code{\link[gasmodel:gas]{gas()}}
\code{\link[gasmodel:wrappers_hessian]{wrappers_hessian}}
}
