      SUBROUTINE PXFAMR( MODE, LFNTER, ISTAT )
C---
C--- ASSEMBLES NUCLEAR FAMILY UNITS FOR PATHMIX PROGRAMS
C---
C--- ARGUMENTS:   MODE   -- 0=INITIALIZE, 1=ACCUMULATE DATA, 2=FINISH
C---              LFNTER -- LOGICAL UNIT FOR ERROR MESSAGES
C---              ISTAT  -- RETURN CODE AS FOLLOWS:
C---                        0=SUCCESSFUL
C---                        1=REQUIRED FIELD IS MISSING
C---
C--- VARIABLES USED:
C---              OLDID  -- FAMILY ID NUMBER
C---              NOMTCH -- NUMBER OF INDIVIDUALS IN CURRENT FAMILY WITH
C---                        A PHENOTYPE BUT NO INDEX
C---
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

#include "field.inc"
#include "path3.inc"

C     IDFLD  -- FIELD NUMBER OF FAMILY ID NUMBER
C     POFLD  -- FIELD NUMBER OF POSITION CODE
C     PHFLD  -- FIELD NUMBER OF PHENOTYPE
C     INFLD  -- FIELD NUMBER OF INDEX

      INTEGER           IDFLD, POFLD, PHFLD, INFLD

C     MAXKID -- LIMIT ON THE NUMBER OF RECORDS IN A FAMILY HAVING A
C               POSITION CODE OF 3
C     NCOUNT -- COUNT OF THE NUMBER OF OBSERVATIONS FALLING IN EACH
C               CATEGORY (PF,IF,PM,IM,PC,IC) IN THE FAMILY
C     BIN    -- QUANTITATIVE DATA, BY CATAGORY, FOR THE CURRENT FAMILY
C     NHELD  -- COUNT OF THE NUMBER OF UNMATCHED CHILD PHENOTYPES
C     TMPBIN -- HOLDING BINS FOR UNMATCHED CHILD PHENOTYPES

      INTEGER           MAXKID
      PARAMETER         (MAXKID=15)

      INTEGER           NCOUNT(NGROUP)
      DOUBLE PRECISION  BIN(MAXKID,NGROUP)
      INTEGER           NHELD
      DOUBLE PRECISION  TMPBIN(MAXKID)

      LOGICAL           BLANKI
      data nheld, nobs /2*0/, famid, oldid /2*-999.999/, xindex /0./
      data ncount /ngroup*0/, bin /(MAXKID*NGROUP)*0./

C === MODE 0 === INITIALIZE PROCESSED FILE =============================

      IF ( MODE .EQ. 0 ) THEN

C        INITIALIZE THE COUNT OF THE NUMBER OF FAMILIES
         NFAM = 0

C        INITIALIZE THE COUNT OF THE NUMBER OF OBSERVATIONS
         NOBS = 0

C        GET FIELD NUMBERS FOR THE FOUR INPUT VARIABLES
         CALL PXINIT( LFNTER, IDFLD, POFLD, PHFLD, INFLD )

C        INITIALIZE COUNTS OF OBSERVATIONS
         DO 100 I=1,NGROUP
            NCOUNT(I) = 0
100      CONTINUE
         NHELD = 0

C        INITIALIZE FAMILY ID
         OLDID = -999.999

         GO TO 700
      END IF

C === MODE 1 OR 2 === COLLECT A FAMILY UNIT ============================

C IF THE FAMILY ID NUMBER HAS CHANGED, THE PREVIOUS FAMILY IS COMPLETE.
C IN THIS CASE, WE SAVE THE DATA FROM THE FAMILY AS A UNIT.

      IF ( MODE .EQ. 1 ) THEN
C        CHECK FOR MISSING ID FIELD
         IF ( FLDOBS(IDFLD) .EQ. FLDBLK(IDFLD) ) GO TO 810
         FAMID = FLDOBS(IDFLD)
      END IF

      IF ( FAMID .NE. OLDID .OR. MODE .EQ. 2 ) THEN

C APPEND UNMATCHED PHENOTYPES TO THE LIST OF MATCHED PHENOTYPES

         IBIN = 5
         DO 210 I=1,NHELD
            NCOUNT(IBIN) = NCOUNT(IBIN) + 1
            BIN( NCOUNT(IBIN), IBIN ) = TMPBIN(I)
210      CONTINUE

C CHECK FOR ZERO OBSERVATIONS IN THE FAMILY

         DO 220 I=1,NGROUP
            IF ( NCOUNT(I) .NE. 0 ) GO TO 230
220      CONTINUE
         GO TO 300

230      CONTINUE

C UPDATE THE COUNT OF FAMILIES

         NFAM = NFAM + 1

         IF ( NFAM .GT. MAXFAM ) THEN
            WRITE (LFNTER,*) '** MAXIMUM NUMBER OF FAMILIES=', MAXFAM
            GO TO 800
         END IF

C SAVE A COUNT OF THE NUMBER OF OBSERVATIONS IN EACH BIN
C THEN SAVE A LINEARIZED LIST OF OBSERVATIONS FROM ALL BINS

         DO 250 I=1,NGROUP

            NLINK(I,NFAM) = NCOUNT(I)

            DO 240 J=1,NCOUNT(I)

C              UPDATE THE TOTAL COUNT OF OBSERVATIONS
               NOBS = NOBS + 1
               IF ( NOBS .GT. MAXOBS ) THEN
                  WRITE (LFNTER,*)
     +               '** MAXIMUM NUMBER OF OBSERVATIONS=', MAXOBS
                  GO TO 800
               END IF
               XOBS(NOBS) = BIN(J,I)

240         CONTINUE

250      CONTINUE

C INITIALIZE NEXT FAMILY

300      CONTINUE

         IF ( MODE .EQ. 2 ) GO TO 700

C        INITIALIZE COUNTS OF OBSERVATIONS
         DO 310 I=1,NGROUP
            NCOUNT(I) = 0
310      CONTINUE
         NHELD = 0

C        SAVE THE NEW FAMILY ID
         OLDID = FAMID
      END IF

C === MODE 1 === ACCUMULATE FAMILY DATA ================================

C GET POSITION CODE

      XPOSIT = FLDOBS( POFLD )
      IF ( XPOSIT .EQ. FLDBLK(POFLD) ) GO TO 810
      IPOSIT = XPOSIT + .5

      IF ( IPOSIT .LT. 1 .OR. IPOSIT .GT. NGROUP/2 ) THEN
         WRITE (LFNTER,*) '** INVALID POSITION CODE **', XPOSIT
         GO TO 800
      END IF

C GET PHENOTYPE

      XPHENO = FLDOBS( PHFLD )
      IF ( XPHENO .EQ. FLDBLK(PHFLD) ) GO TO 810

C GET ENVIRONMENTAL INDEX

C  the following line inserted by R.Wette (10/JAN/89)
      BLANKI = .FALSE.

      IF ( INFLD .EQ. 0 ) THEN
C        SET FLAG FOR MISSING INDEX
         BLANKI = .TRUE.
      ELSE
         XINDEX = FLDOBS( INFLD )
         IF ( XINDEX .EQ. FLDBLK(INFLD) ) BLANKI = .TRUE.
      END IF

C COMPUTE BIN NUMBER (PF=1,IF=2,PM=3,IM=4,PC=5,IC=6)

      IBIN = ( 2 * IPOSIT ) - 1

C     CHECK AGAINST THE LIMIT ON THE NUMBER OF OBSERVATIONS
C     (ONLY NEED TO CHECK PHENOS SINCE INDICES ARE EQUAL OR FEWER)

      IF ( IPOSIT .LE. 2 ) THEN
         IF ( NCOUNT(IBIN) .EQ. 1 ) THEN
            WRITE (LFNTER,*) '** ERROR IN DATA FILE ** FAMILY',
     +         FAMID, ' HAS >1 FATHER OR MOTHER'
            GO TO 800
         END IF

      ELSE
         IF ( NCOUNT(IBIN) .EQ. 10 ) THEN
            WRITE (LFNTER,*) '** ERROR IN DATA FILE ** FAMILY',
     +         FAMID, ' HAS >', MAXKID, ' KIDS'
            GO TO 800
         END IF
      END IF

C ADD DATA TO THE APPROPRIATE BINS (PF,IF,PM,PC,IC)

      IF ( IBIN .GT. 4 .AND. BLANKI ) THEN
C        SAVE UNMATCHED KID'S PHENOTYPES IN A SEPARATE HOLD AREA
         NHELD = NHELD + 1
         TMPBIN( NHELD ) = XPHENO
      ELSE

C        PHENOTYPE:
         NCOUNT(IBIN) = NCOUNT(IBIN) + 1
         BIN( NCOUNT(IBIN), IBIN ) = XPHENO

C        INDEX:
         IF ( .NOT. BLANKI ) THEN
            IBIN = IBIN + 1
            NCOUNT(IBIN) = NCOUNT(IBIN) + 1
            BIN( NCOUNT(IBIN), IBIN ) = XINDEX
         END IF
      END IF

700   ISTAT = 0
      RETURN

C     REQUIRED FIELD MISSING
810   ISTAT = 1

800   call intpr('PATHMIX: CODING ERROR IN DATA FILE',-1,0,0)
      STOP
      END

      SUBROUTINE PXINIT( LFNTER, IDFLD, POFLD, PHFLD, INFLD )
C---
C--- INITIALIZATION FOR PXFAMR
C---
C--- INPUT ARGUMENTS:
C---     LFNTER -- LOGICAL UNIT FOR ERROR MESSAGES
C---
C--- RETURNED ARGUMENTS:
C---     IDFLD  -- FIELD NUMBER OF FAMILY ID NUMBER
C---     POFLD  -- FIELD NUMBER OF POSITION CODE
C---     PHFLD  -- FIELD NUMBER OF PHENOTYPE
C---     INFLD  -- FIELD NUMBER OF INDEX
C---
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      INTEGER           IDFLD, POFLD, PHFLD, INFLD

#include "field.inc"

C     FIND VARIABLES NAMED "ID", "PO", "PH", AND "IN"

      IDFLD = 0
      POFLD = 0
      PHFLD = 0
      INFLD = 0

      DO 10 I=1,MAXFLD
         IF ( FLDNAM(I) .EQ. 'ID' ) IDFLD = I
         IF ( FLDNAM(I) .EQ. 'PO' ) POFLD = I
         IF ( FLDNAM(I) .EQ. 'PH' ) PHFLD = I
         IF ( FLDNAM(I) .EQ. 'IN' ) INFLD = I
10    CONTINUE

C MAKE SURE THE THREE REQUIRED FIELDS ARE PRESENT

      IF ( IDFLD .EQ. 0 ) THEN
         WRITE (LFNTER,*) '** VARIABLE "ID" NOT FOUND IN FM CARD **'
         GO TO 800
      END IF

      IF ( POFLD .EQ. 0 ) THEN
         WRITE (LFNTER,*) '** VARIABLE "PO" NOT FOUND IN FM CARD **'
         GO TO 800
      END IF

      IF ( PHFLD .EQ. 0 ) THEN
         WRITE (LFNTER,*) '** VARIABLE "PH" NOT FOUND IN FM CARD **'
         GO TO 800
      END IF

      RETURN

800   call intpr('PATHMIX: ERROR IN JOB FILE',-1,0,0)
      STOP
      END
