% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Segment-generics.R, R/Segment-methods.R
\docType{methods}
\name{Segment}
\alias{Segment}
\alias{Segment,numeric-method}
\alias{Segment,character-method}
\alias{Segment,ANY-method}
\alias{Segment,NULL-method}
\alias{Segment,gaUserSegment-method}
\title{Segment}
\usage{
Segment(object, ...)

\S4method{Segment}{numeric}(object)

\S4method{Segment}{character}(object)

\S4method{Segment}{ANY}(object, ...)

\S4method{Segment}{`NULL`}(object)

\S4method{Segment}{gaUserSegment}(object)
}
\arguments{
\item{object}{A segment or other object that can be coerced into a segment,
including dynamic segments, built-in and/or custom segments by their ID.}

\item{...}{Other segment conditions, filters or filter lists to include in
the segment's definition (ANDed)}
}
\value{
An object belonging to the \code{.gaSegment} superclass.
}
\description{
Define a segment for use in a query's segment list.
}
\section{Methods (by class)}{
\itemize{
\item \code{numeric}: Interpret the supplied numeric value as a segment ID.

\item \code{character}: Interpret the supplied character value as a segment ID.

\item \code{ANY}: Create a non-sequential segment using the supplied
expressions.

\item \code{NULL}: returns NULL

\item \code{gaUserSegment}: Return the segment ID of the supplied GA Management API
user segment.
}}

\seealso{
Other dynamic segment functions: \code{\link{DynSegment}},
  \code{\link{Exclude}}, \code{\link{Include}},
  \code{\link{IsNegated}}, \code{\link{PerHit}},
  \code{\link{PerProduct}}, \code{\link{PerSession}},
  \code{\link{PerUser}}, \code{\link{ScopeLevel}},
  \code{\link{SegmentConditionFilter}},
  \code{\link{Segments}}
}
\concept{dynamic segment functions}
