% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.gamsel.R
\name{print.gamsel}
\alias{print.gamsel}
\title{print a gamsel object}
\usage{
\method{print}{gamsel}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{fitted gamsel object}

\item{digits}{significant digits in printout}

\item{\dots}{additional print arguments}
}
\value{
The matrix above is silently returned
}
\description{
Print a summary of the gamsel path at each step along the path
}
\details{
The call that produced the object \code{x} is printed, followed by a
five-column matrix with columns \code{NonZero}, \code{Lin}, \code{NonLin}, \verb{\%Dev}
and \code{Lambda}.  The first three columns say how many nonzero, linear
and nonlinear terms there are. \verb{\%Dev} is the percent deviance
explained (relative to the null deviance).
}
\references{
Chouldechova, A. and Hastie, T. (2015) \emph{Generalized Additive Model Selection}
}
\seealso{
\link{predict.gamsel}, \link{cv.gamsel},
\link{plot.gamsel}, \link{summary.gamsel},
\link{basis.gen}
}
\author{
Alexandra Chouldechova and Trevor Hastie\cr Maintainer: Trevor
Hastie \email{hastie@stanford.edu}
}
\keyword{nonparametric}
\keyword{regression}
\keyword{smooth}
