% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{Baseline-class}
\alias{Baseline-class}
\alias{.Baseline}
\alias{BaseLine-class}
\title{An S4 Class to Represent a Spectrum Baseline}
\description{
An S4 Class to Represent a Spectrum Baseline
}
\note{
This class extends the \linkS4class{GammaSpectrum} class.
}
\examples{
## Import a CNF file
spc_file <- system.file("extdata/LaBr.CNF", package = "gamma")
spc <- read(spc_file)

## Remove the first 35 channels
spc <- signal_slice(spc, -c(1:35))

## Linear baseline
bsl_linear <- baseline_linear(spc, from = 250, to = 750)
plot(spc, bsl_linear)

## SNIP baseline
bsl_snip <- baseline_snip(spc, LLS = FALSE, decreasing = FALSE, n = 100)
plot(spc, bsl_snip)

## Rubberband baseline
bsl_rubber <- baseline_rubberband(spc)
plot(spc, bsl_rubber)

## Remove baseline
spc_clean1 <- signal_correct(spc)
spc_clean2 <- spc - bsl_snip
all(spc_clean1 == spc_clean2)

plot(spc_clean1)
}
\seealso{
Other class: 
\code{\link{CalibrationCurve-class}},
\code{\link{GammaSpectra-class}},
\code{\link{GammaSpectrum-class}},
\code{\link{PeakPosition-class}},
\code{\link{coerce}()}
}
\author{
N. Frerebeau
}
\concept{class}
