% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/predProbs.r
\name{predProbs}
\alias{predProbs}
\title{User-friendly predicted probability analysis}
\usage{
predProbs(model, x, xlim = c(min(x), max(x)), n = 100, ci = 0.95,
  type = c("outcome", "action"), makePlots = FALSE, report = TRUE, ...)
}
\arguments{
\item{model}{a fitted model of class \code{game}.}

\item{x}{character string giving the name of the variable to place "on the
x-axis" while all others are held constant.  Partial matches are accepted.}

\item{xlim}{numeric, length 2: the range that \code{x} should be varied over
(if \code{x} is continuous).  Defaults to the observed range of \code{x}.}

\item{n}{integer: the number of observations to generate (if \code{x} is
continuous).}

\item{ci}{numeric: width of the confidence interval to estimate around each
predicted probability.  Set to \code{0} to estimate no confidence intervals.}

\item{type}{whether to generate predicted values for outcomes (the default)
or actions}

\item{makePlots}{logical: whether to automatically make the default plot
for the returned object.  See \code{\link{plot.predProbs}}.}

\item{report}{logical: whether to print a status bar while obtaining the
confidence intervals for the predicted probabilities.}

\item{...}{used to set values for variables other than \code{x} in the
profile of observations.  See "Details" and "Examples".}
}
\value{
An object of class \code{predProbs}.  This is a data frame containing
each hypothetical observation's predicted probability, the upper and lower
bounds of the confidence interval, and the value of each regressor.
}
\description{
Easy generation and plotting of predicted probabilities from a fitted
strategic model.
}
\details{
\code{predProbs} provides an easy way to analyze the estimated marginal
effect of an independent variable on the probability of particular outcomes,
using the estimates returned by a strategic model.  The procedure is
designed so that, for a preliminary analysis, the user can simply specify
the fitted model and the independent variable of interest, and quickly
obtain plots of predicted probabilities.  However, it is flexible enough to
allow for finely tuned analysis as well.

The procedure works by varying \code{x}, the variable of interest, across
its observed range (or one specified by the user in \code{xlim}) while
holding all other independent variables in the model fixed.  The profile
created by default is as follows (the same defaults as in the \code{sim}
function in the \pkg{Zelig} package):
\itemize{
\item numeric, non-binary variables are fixed at their means
\item \code{\link{ordered}} variables are fixed at their medians
\item all others are fixed at their modes (see \code{\link{Mode}})}
However, it is possible to override these defaults for any or all
variables.  For example, to set a variable named \code{polity} to its lower
quartile, call \code{predProbs} with the argument \code{polity =
quantile(polity, 0.25)}.  To set a factor variable to a particular level,
provide the name of the level as a character string (in quotes). (Also see
the examples below.)

Confidence intervals for each predicted point are generated by bootstrap.
If \code{model} has a non-null \code{boot.matrix} element (i.e., a bootstrap
was performed with the model fitting), then these results are used to
make the confidence intervals.  Otherwise, a parametric bootstrap sample is
generated by sampling from a multivariate normal distribution around the
parameter estimates.  In this case, a warning is issued.

For information on plotting the predicted probabilities, see
\code{\link{plot.predProbs}}.  The plots are made with base graphics.  If you
prefer to use an alternative graphics package, all the information necessary
to make the plots is included in the data frame returned.
}
\examples{
data("war1800")
f1 <- esc + war ~ s_wt_re1 + revis1 | 0 | regime1 | balanc + regime2
m1 <- egame12(f1, data = war1800, boot = 10)

pp1 <- predProbs(m1, x = "s_wt_re1", n = 5)
print(pp1)  ## Hypothetical observations and their predicted probs
plot(pp1, which = 2)  ## See ?plot.predProbs for more plot examples

## Changing the profile used
pp2 <- predProbs(m1, x = "s_wt_re1", n = 5, revis1 = 1, balanc = 0.7)
pp3 <- predProbs(m1, x = "s_wt_re1", n = 5, regime1 = "dem")
pp4 <- predProbs(m1, x = "s_wt_re1", n = 5, balanc = median(balanc))

## Variable names (other than `x`) must match exactly!
\dontrun{
    pp5 <- predProbs(m1, x = "s_wt_re1", bal = 0.7)  ## Error will result
}

## `x` can be a factor too
pp6 <- predProbs(m1, x = "regime1")

## Action probabilities
pp7 <- predProbs(m1, x = "regime1", type = "action")
}
\author{
Brenton Kenkel (\email{brenton.kenkel@gmail.com}).  Code for
escaping special regex characters was taken from the \code{Hmisc} package's
function \code{escapeRegex}, written by Charles Dupont.
}
\seealso{
\code{\link{predict.game}} for somewhat more flexible (but fussier)
generation of predicted probabilities.
}

