% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cognition}
\alias{cognition}
\title{Simulated Data with Measurements of Cognitive Abilities}
\format{
\subsection{\code{cognition} A data frame with 14400 rows and 7 columns:}{

\describe{
\item{id}{Subject ID.}
\item{domain}{Factor variable denoting the cognitive domain.}
\item{x}{Explanatory variable.}
\item{timepoint}{Factor variable denoting the timepoint.}
\item{item}{Factor variable denoting the item within the tests of each
cognitive domain.}
\item{trials}{Number of trials, if applicable.}
\item{y}{Response variable. For domain 1 a real number, for domain 2 a
binomially distributed variable based on a single trial, for
domain 3 a real number.}
}
}
}
\usage{
cognition
}
\description{
Simulated dataset mimicking the measurement of abilities in three cognitive
domains. The latent traits (cognitive ability in a given domain) are based on
the functions in \code{mgcv::gamSim}
\insertCite{woodGeneralizedAdditiveModels2017a}{galamm}, and depend on the
explanatory variable x.
}
\references{
\insertAllCited{}
}
\seealso{
Other datasets: 
\code{\link{diet}},
\code{\link{epilep}},
\code{\link{hsced}},
\code{\link{latent_covariates}},
\code{\link{latent_covariates_long}},
\code{\link{lifespan}},
\code{\link{mresp}},
\code{\link{mresp_hsced}}
}
\concept{datasets}
\keyword{datasets}
