% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_crop.R
\name{st_crop.data_request}
\alias{st_crop.data_request}
\title{Narrow a query to within a specified polygon}
\usage{
\method{st_crop}{data_request}(x, y, ...)
}
\arguments{
\item{x}{An object of class \code{data_request}, created using \code{\link[=galah_call]{galah_call()}}}

\item{y}{A single \code{sf} object, WKT string or shapefile}

\item{...}{currently ignored}
}
\description{
Restrict results to those from a specified area. Areas must be polygons.
Polygons must be supplied as an \code{sf} object, a 'well-known text' (WKT)
string, or a shapefile. Polygons and shapefiles must not be overly complex
(i.e. have too many characters or too many vertices) or they will not be
accepted in a query to the ALA.

\code{st_crop} is masked from \code{sf}, but when piped after \code{\link[=galah_call]{galah_call()}}, is
functionally  synonymous with \code{\link[=galah_polygon]{galah_polygon()}}
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\seealso{
\code{\link[=galah_polygon]{galah_polygon()}}, with which this function is synonymous.
}
