% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-utilities.R
\name{graph-clique}
\alias{graph-clique}
\alias{get_cliques}
\alias{max_cliqueMAT}
\alias{getCliques}
\alias{maxCliqueMAT}
\title{Get cliques of an undirected graph}
\usage{
get_cliques(object)

max_cliqueMAT(amat)

getCliques(object)

maxCliqueMAT(amat)
}
\arguments{
\item{object}{An undirected graph represented either as a \code{graphNEL}
object, an \code{igraph} object, a (dense) \code{matrix}, a (sparse) \code{dgCMatrix}}

\item{amat}{An adjacency matrix.}
}
\value{
A list.
}
\description{
Return a list of (maximal) cliques of an undirected graph.
}
\details{
In graph theory, a clique is often a complete subset of a
graph. A maximal clique is a clique which can not be
enlarged. In statistics (and that is the convention we follow
here) a clique is usually understood to be a maximal clique.

Finding the cliques of a general graph is an NP complete problem. Finding
the cliques of triangualted graph is linear in the number of cliques.

The workhorse is the \code{max_cliqueMAT} function which calls the
\code{maxClique} function in the \code{RBGL} package.
}
\section{Synonymous functions}{


For backward compatibility with downstream packages we have the
following synonymous functions:
\itemize{
\item getCliques = get_cliques
\item maxCliqueMAT = max_cliqueMAT
}
}

\examples{
## graphNEL
uG0 <- ug(~a:b + b:c + c:d + d:e + e:f + f:a) # a graphNEL object
get_cliques(uG0)

uG1 <- as(uG0, "igraph")
get_cliques(uG1)

uG2 <- as(uG0, "matrix") 
get_cliques(uG2)

uG3 <- as(uG1, "dgCMatrix") 
get_cliques(uG3)
}
\seealso{
\code{\link{ug}}, \code{\link{dag}}, \code{\link{mcs}},
\code{\link{mcsMAT}}, \code{\link{rip}}, \code{\link{ripMAT}},
\code{\link{moralize}}, \code{\link{moralizeMAT}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
