% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_array-algebra.R
\name{array-algebra}
\alias{\%a*\%}
\alias{\%a+\%}
\alias{\%a-\%}
\alias{\%a/0\%}
\alias{\%a/\%}
\alias{ar_add}
\alias{ar_div}
\alias{ar_div0}
\alias{ar_mult}
\alias{ar_prod}
\alias{ar_subt}
\alias{ar_sum}
\alias{array-algebra}
\alias{tabAdd}
\alias{tabDiv}
\alias{tabDiv0}
\alias{tabMult}
\alias{tabProd}
\alias{tabSubt}
\alias{tabSum}
\title{Array algebra}
\usage{
a1 \%a+\% a2

a1 \%a-\% a2

a1 \%a*\% a2

a1 \%a/\% a2

a1 \%a/0\% a2

ar_add(a1, a2)

ar_subt(a1, a2)

ar_mult(a1, a2)

ar_div(a1, a2)

ar_div0(a1, a2)

ar_sum(...)

ar_prod(...)
}
\arguments{
\item{a, a1, a2, ...}{Arrays (with named dimnames)}
}
\description{
Addition, subtraction etc. of arrays
}
\examples{
hec <- HairEyeColor
a1 <- ar_marg(hec, c("Hair", "Eye"))
a2 <- ar_marg(hec, c("Hair", "Sex"))
a3 <- ar_marg(hec, c("Eye", "Sex"))

## Binary operations
a1 \%a+\% a2
a1 \%a-\% a2
a1 \%a*\% a2
a1 \%a/\% a2

ar_sum(a1, a2, a3)
ar_prod(a1, a2, a3)

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}

