% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_cpt.R
\name{replace-cpt}
\alias{replace-cpt}
\alias{replaceCPT}
\alias{replaceCPT.cpt_grain}
\title{Replace CPTs in Bayesian network}
\usage{
replaceCPT(object, value)

\method{replaceCPT}{cpt_grain}(object, value)
}
\arguments{
\item{object}{A \code{grain} object.}

\item{value}{A named list, see examples below.}
}
\description{
Replace CPTs of Bayesian network.
}
\details{
When a Bayesian network (BN) is constructed from a list of
conditional probability tables (CPTs) (e.g. using the function
\code{grain()}), various actions are taken:
\enumerate{
\item It is checked that the list of CPTs define a directed acyclic graph (DAG).
\item The DAG is moralized and triangulated.
\item A list of clique potentials (one for each clique in the
triangulated graph) is created from the list of CPTs.
\item The clique potentials are, by default, calibrated to each other
so that the potentials contain marginal distributions.
}

The function described here bypass the first two steps which can
provide an important gain in speed compared to constructing a new
BN with a new set of CPTs with the same DAG.
}
\examples{
## See the wet grass example at
## https://en.wikipedia.org/wiki/Bayesian_network

yn <- c("yes", "no")
p.R    <- cptable(~R, values=c(.2, .8), levels=yn)
p.S_R  <- cptable(~S:R, values=c(.01, .99, .4, .6), levels=yn)
p.G_SR <- cptable(~G:S:R, values=c(.99, .01, .8, .2, .9, .1, 0, 1), levels=yn)

wet.bn <- compileCPT(p.R, p.S_R, p.G_SR)  |> grain()
getgrain(wet.bn, "cpt")[c("R","S")]

# Update some CPTs
wet.bn <- replaceCPT(wet.bn, list(R=c(.3, .7), S=c(.1, .9, .7, .3)))
getgrain(wet.bn, "cpt")[c("R","S")]

}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
with the gRain Package for R. Journal of Statistical Software,
46(10), 1-26.  \url{https://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{grain}}, \code{\link[gRbase]{propagate}},
\code{\link[gRbase]{triangulate}}, \code{\link[gRbase]{rip}},
\code{\link[gRbase]{junctionTree}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
\keyword{utilities}
