% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grain-set-slot.R
\name{set-slot}
\alias{set-slot}
\alias{set_rip}
\alias{set_ug}
\alias{set_cpt}
\title{Update components of Bayesian network}
\usage{
set_rip(object, value)

set_ug(object, value)

set_cpt(object, list, value)
}
\arguments{
\item{object}{A grain object}

\item{value}{A named list}

\item{list}{Entries to be replaced.}
}
\description{
Update components of Bayesian network.
}
\examples{

yn = c("yes", "no")
universe = list(flu=yn, temp=yn, headache=yn)
p.f   = tab(~flu, levels=universe, values=c(.1, .9))
p.t_f = tab(~temp|flu, levels=universe, values=c(.9, .1, .01, .99))
p.h_t = tab(~headache|temp, levels=universe, values=c(.8, .1, .1, .9))

pl = compileCPT(list(p.f, p.t_f, p.h_t))
pl
bn = compile(grain(pl))
bn = propagate(bn)
bn
cp = cpt(bn)
cp1 = cp[[1]]
cp1
}
\references{
Søren Højsgaard (2012). Graphical Independence
Networks with the gRain Package for R. Journal of Statistical
Software, 46(10), 1-26.
\url{http://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{grain}}, \code{\link[gRbase]{propagate}},
\code{\link[gRbase]{triangulate}}, \code{\link[gRbase]{rip}},
\code{\link[gRbase]{junctionTree}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
\keyword{utilities}
