% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPT-POT-compile.R
\name{compile_components}
\alias{compile_components}
\alias{compile_cpt}
\alias{compileCPT}
\alias{compilePOT}
\alias{compile_pot}
\title{Compile conditional probability tables / cliques potentials.}
\usage{
compile_cpt(x, forceCheck = TRUE)

compile_pot(x)
}
\arguments{
\item{x}{To \code{compile_cpt} x is a list of conditional
probability tables; to \code{compile_pot}, x is a list of clique
potentials.}

\item{forceCheck}{Controls if consistency checks of the probability
tables should be made.}

\item{...}{Additional arguments; currently not used.}
}
\value{
A list with a class attribute.
}
\description{
Compile conditional probability tables / cliques
potentials as a preprocessing step for creating a graphical
independence network
}
\details{
\code{compileCPT}, \code{compilePOT} are wrappers for
\code{compile_cpt} and \code{compile_pot} and are kept for
backward compatibility.
}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
with the gRain Package for R. Journal of Statistical Software,
46(10), 1-26.  \url{http://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{extract_cpt}}, \code{\link{extract_pot}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
