/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.gui.graph.Node;
import org.mutoss.gui.graph.NodeListener;
import org.mutoss.gui.graph.PView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPanel
implements ActionListener,
KeyListener,
NodeListener {
    private static final Log logger = LogFactory.getLog(PPanel.class);
    double p = 0.0;
    double w;
    String name;
    JLabel label;
    JTextField wTF;
    JTextField pTF;
    JButton jb;
    Node node;
    PView pview;
    Boolean rejected = false;
    DecimalFormat format = new DecimalFormat("#.#####");
    static boolean testing;

    public Vector<Component> getComponent() {
        Vector<Component> v = new Vector<Component>();
        v.add(this.label);
        v.add(this.wTF);
        v.add(this.pTF);
        v.add(this.jb);
        return v;
    }

    public PPanel(Node node, PView pview) {
        node.addNodeListener(this);
        this.name = node.name;
        this.w = node.getAlpha();
        this.node = node;
        this.pview = pview;
        this.label = new JLabel(this.name);
        this.wTF = new JTextField(this.format.format(this.w), 7);
        this.wTF.addActionListener(this);
        this.wTF.addKeyListener(this);
        this.pTF = new JTextField(this.format.format(this.p), 7);
        this.pTF.addActionListener(this);
        this.pTF.addKeyListener(this);
        this.jb = new JButton("Reject and pass \u03b1");
        this.jb.setEnabled(false);
        this.jb.addActionListener(this);
        if (node.isRejected()) {
            this.reject();
        } else {
            this.keyTyped(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb) {
            this.reject();
            this.updateGraph();
        } else {
            this.keyTyped(null);
        }
    }

    private void reject() {
        this.wTF.setEnabled(false);
        this.pTF.setEnabled(false);
        this.jb.setEnabled(false);
        this.label.setText(this.label.getText() + " rejected!");
        this.label.setForeground(new Color(0, 100, 0));
        this.node.setColor(new Color(50, 255, 50));
        this.rejected = true;
    }

    private void updateGraph() {
        this.node.vs.nl.acceptNode(this.node);
        this.pview.recalculate();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyTyped(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyTyped(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        try {
            this.p = Double.parseDouble(this.pTF.getText().replace(",", "."));
            this.pTF.setBackground(Color.WHITE);
        }
        catch (NumberFormatException nfe) {
            this.pTF.setBackground(Color.RED);
        }
        try {
            this.w = Double.parseDouble(this.wTF.getText().replace(",", "."));
            this.wTF.setBackground(Color.WHITE);
        }
        catch (NumberFormatException nfe) {
            this.wTF.setBackground(Color.RED);
        }
        this.node.setAlpha(this.w, this);
        if (this.p <= this.w) {
            this.node.setColor(new Color(50, 255, 50));
            this.wTF.setBackground(new Color(50, 255, 50));
            if (testing) {
                this.jb.setEnabled(true);
            } else {
                this.jb.setEnabled(false);
            }
        } else {
            this.node.setColor(Color.WHITE);
            this.wTF.setBackground(Color.WHITE);
            this.jb.setEnabled(false);
        }
        if (testing) {
            this.wTF.setEditable(false);
            this.pTF.setEditable(false);
        } else {
            this.wTF.setEditable(true);
            this.pTF.setEditable(true);
        }
        this.pview.updateLabels();
    }

    public void update() {
        this.name = this.node.name;
        this.w = this.node.getAlpha();
        this.wTF.setText(this.format.format(this.w).replace(",", "."));
        this.pTF.setText(this.format.format(this.p).replace(",", "."));
        if (!this.rejected.booleanValue()) {
            this.keyTyped(null);
        }
    }

    @Override
    public void updated(Node node) {
        this.name = node.name;
        this.w = node.getAlpha();
        this.wTF.setText(this.format.format(this.w).replace(",", "."));
        this.pTF.setText(this.format.format(this.p).replace(",", "."));
        this.pview.updateLabels();
    }

    public double getP() {
        return this.p;
    }

    public void setP(double p) {
        this.p = p;
        this.update();
    }

    public static void setTesting(boolean b) {
        testing = b;
    }
}

