/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.datatable;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.mutoss.gui.datatable.CellValue;
import org.mutoss.gui.datatable.DataTableModel;
import org.mutoss.gui.datatable.EpsilonTableCellRenderer;
import org.mutoss.gui.datatable.HeaderCellValue;
import org.mutoss.gui.datatable.HeaderRenderer;
import org.mutoss.gui.datatable.JXTable2;
import org.mutoss.gui.datatable.RDataFrameRef;

public class DataTable
extends JXTable2 {
    public static final Color NUM_COLOR = Color.BLUE;
    public static final Color INT_COLOR = new Color(0, 155, 0);
    public static final Color FACTOR_COLOR = Color.RED;
    public static final Color CHAR_COLOR = Color.GREEN;
    public static final Color LOGICAL_COLOR = Color.PINK;

    public DataTable(RDataFrameRef df) {
        this(new DataTableModel(df));
    }

    public DataTable(DataTableModel dataTableModel) {
        super(dataTableModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setAutoResizeMode(0);
        this.setDefaultRenderer(CellValue.class, new EpsilonTableCellRenderer());
        this.setTableHeaderRenderer();
    }

    public DataTableModel getModel() {
        return (DataTableModel)super.getModel();
    }

    public void update() {
        this.getModel().fireTableStructureChanged();
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        return new Dimension(Math.min(this.getPreferredSize().width, size.width), size.height);
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getAutoResizeMode() == 0 ? this.getParent().getWidth() > this.getPreferredSize().width : super.getScrollableTracksViewportWidth();
    }

    public String getColumnVar(int col) {
        return this.getModel().getColumnName(col);
    }

    private void setTableHeaderRenderer() {
        TableCellRenderer r = this.getTableHeader().getDefaultRenderer();
        this.getTableHeader().setDefaultRenderer(new HeaderRenderer(r));
    }

    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        for (int j = 0; j < this.getColumnCount(); ++j) {
            TableColumn aColumn = this.getColumn(j);
            int i = aColumn.getModelIndex();
            String name = this.getModel().getColumnName(i);
            double[] dfCol = this.getModel().getDataFrame().getCol(i);
            aColumn.setHeaderValue(new HeaderCellValue(name, dfCol));
        }
    }

    public void addColumn(TableColumn aColumn) {
        int i = aColumn.getModelIndex();
        String name = this.getModel().getColumnName(i);
        double[] dfCol = this.getModel().getDataFrame().getCol(i);
        aColumn.setHeaderValue(new CellValue(name, dfCol));
        super.addColumn(aColumn);
    }
}

