% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{g6_add_nodes}
\alias{g6_add_nodes}
\alias{g6_add_edges}
\alias{g6_add_combos}
\alias{g6_add_data}
\title{Add nodes/edges/combos to a g6 graph via proxy}
\usage{
g6_add_nodes(graph, nodes)

g6_add_edges(graph, edges)

g6_add_combos(graph, combos)

g6_add_data(graph, data)
}
\arguments{
\item{graph}{A g6_proxy object created with \code{\link{g6_proxy}}.}

\item{nodes, edges, combos}{A data frame or list specifying the elements to be added.
Elements structure must be compliant with specifications listed at
\url{https://g6.antv.antgroup.com/manual/element/overview}}

\item{data}{A nested list possibly containing nodes, edges and combo data.}
}
\value{
The g6_proxy object (invisibly), allowing for method chaining.
}
\description{
This function adds one or more nodes/edges/combos to an existing g6 graph instance
using a proxy object. This allows updating the graph without completely
re-rendering it.
}
\details{
This function can only be used with a g6_proxy object within a Shiny application.
It will not work with regular g6 objects outside of Shiny.

If a node with the same ID already exists, it will not be added again.
See \url{https://g6.antv.antgroup.com/en/api/data#graphaddnodedata},
\url{https://g6.antv.antgroup.com/en/api/data#graphaddedgedata} and
\url{https://g6.antv.antgroup.com/en/api/data#graphaddcombodata} for more details.
}
\seealso{
\code{\link{g6_proxy}}, \code{\link{g6_remove_nodes}}
}
