% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_w.R
\docType{class}
\name{FuzzExtract}
\alias{FuzzExtract}
\title{Fuzzy extraction from a sequence}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
# init <- FuzzExtract$new(decoding = NULL)
}
\arguments{
\item{decoding}{either NULL or a character string. If not NULL then the \emph{decoding} parameter takes one of the standard python encodings (such as 'utf-8'). See the \emph{details} and \emph{references} link for more information.}

\item{string}{a character string.}

\item{sequence_strings}{a character string vector}

\item{contains_dupes}{a vector of strings that we would like to dedupe}

\item{processor}{either NULL or a function of the form f(a) -> b, where a is the query or individual choice and b is the choice to be used in matching. See the examples for more details.}

\item{scorer}{a function for scoring matches between the query and an individual processed choice. This should be a function of the form f(query, choice) -> int. By default, FuzzMatcher.WRATIO() is used and expects both query and choice to be strings. See the examples for more details.}

\item{limit}{An integer value for the maximum number of elements to be returned. Defaults to 5L}

\item{score_cutoff}{an integer value for the score threshold. No matches with a score less than this number will be returned. Defaults to 0}

\item{threshold}{the numerical value (0, 100) point at which we expect to find duplicates. Defaults to 70 out of 100}
}
\description{
Fuzzy extraction from a sequence
}
\details{
the \emph{decoding} parameter is useful in case of non-ascii character strings. If this parameter is not NULL then the \emph{force_ascii} parameter (if applicable) is internally set to FALSE. Decoding applies only to python 2 configurations, as in python 3 character strings are decoded to unicode by default.

the \emph{Extract} method selects the best match of a character string vector. It returns a list with the match and it's score.

the \emph{ExtractBests} method returns a list of the best matches for a sequence of character strings.

the \emph{ExtractWithoutOrder} method returns the best match of a character string vector (in python it returns a generator of tuples containing the match and it's score).

the \emph{ExtractOne} method finds the single best match above a score for a character string vector. This is a convenience method which returns the single best choice.

the \emph{Dedupe} is a convenience method which takes a character string vector containing duplicates and uses fuzzy matching to identify and remove duplicates. Specifically, it uses the \emph{Extract} method
to identify duplicates that score greater than a user defined threshold. Then, it looks for the longest item in the duplicate vector since we assume this item contains the most entity information and returns that.
It breaks string length ties on an alphabetical sort. Note: as the threshold DECREASES the number of duplicates that are found INCREASES. This means that the returned deduplicated list will likely be shorter.
Raise the threshold for fuzzy_dedupe to be less sensitive.
}
\section{Methods}{


\describe{
 \item{\code{FuzzExtract$new(decoding = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{Extract(string = NULL, sequence_strings = NULL, processor = NULL, scorer = NULL, limit = 5L)}}{}

 \item{\code{--------------}}{}

 \item{\code{ExtractBests(string = NULL, sequence_strings = NULL, processor = NULL, scorer = NULL, score_cutoff = 0L, limit = 5L)}}{}

 \item{\code{--------------}}{}

 \item{\code{ExtractWithoutOrder(string = NULL, sequence_strings = NULL, processor = NULL, scorer = NULL, score_cutoff = 0L)}}{}

 \item{\code{--------------}}{}

 \item{\code{ExtractOne(string = NULL, sequence_strings = NULL, processor = NULL, scorer = NULL, score_cutoff = 0L)}}{}

 \item{\code{--------------}}{}

 \item{\code{Dedupe(contains_dupes = NULL, threshold = 70L, scorer = NULL)}}{}

 }
}

\examples{

if (check_availability()) {


  library(fuzzywuzzyR)

  word = "new york jets"

  choices = c("Atlanta Falcons", "New York Jets", "New York Giants", "Dallas Cowboys")

  duplicat = c('Frodo Baggins', 'Tom Sawyer', 'Bilbo Baggin', 'Samuel L. Jackson',

               'F. Baggins', 'Frody Baggins', 'Bilbo Baggins')

  #------------
  # processor :
  #------------

  init_proc = FuzzUtils$new()

  PROC = init_proc$Full_process    # class process-method

  PROC1 = tolower                  # base R function

  #---------
  # scorer :
  #---------

  init_scor = FuzzMatcher$new()

  SCOR = init_scor$WRATIO


  init <- FuzzExtract$new()

  init$Extract(string = word, sequence_strings = choices, processor = PROC, scorer = SCOR)

  init$ExtractBests(string = word, sequence_strings = choices, processor = PROC1,

                    scorer = SCOR, score_cutoff = 0L, limit = 2L)

  init$ExtractWithoutOrder(string = word, sequence_strings = choices, processor = PROC,

                           scorer = SCOR, score_cutoff = 0L)

  init$ExtractOne(string = word, sequence_strings = choices, processor = PROC,

                  scorer = SCOR, score_cutoff = 0L)

  init$Dedupe(contains_dupes = duplicat, threshold = 70L, scorer = SCOR)


}
}
\references{
https://github.com/seatgeek/fuzzywuzzy/blob/master/fuzzywuzzy/process.py, https://docs.python.org/3/library/codecs.html#standard-encodings
}
\keyword{datasets}
