% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{processReference}
\alias{processReference}
\title{Get projection data for reference period}
\usage{
processReference(model, global, custom)
}
\arguments{
\item{model}{List with parsed information about the directory structure for
a specific climate model from the user-specified projections directory.
This list is a subset of the list generated by
\code{acquireDirectoryStructure}.}

\item{global}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the path to the output directory, the
path to the input climate projections, the dataframe with city
locations).}

\item{custom}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the name of the R function to
use to identify heat waves, alternative upper and lower year boundaries
for the data used to determine threshold temperatures for the heat wave
definition, alternative upper and lower year boundaries
for the projection period of the heat wave datasets being generated).}
}
\value{
A list with, among other elements, a \code{series} element with
the time series of projected temperatures for the reference period for each
study city.
}
\description{
This function is only run if the reference period is different from the
projection period. In that case, this function will acquire the time series
of projected temperatures during the indicated reference period and pass
that through to be used in a later function to characterize heat waves.
}

