% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plan.R
\name{plan}
\alias{plan}
\title{Plan how to resolve a future}
\usage{
plan(strategy = NULL, ..., substitute = TRUE, .call = TRUE)
}
\arguments{
\item{strategy}{The evaluation function to use for resolving a future.
If NULL, then the current strategy is returned.}

\item{substitute}{If TRUE, the \code{strategy} expression is
\code{substitute()}:d, otherwise not.}

\item{.call}{(internal) Used to record the call to this function.}

\item{\dots}{Additional arguments overriding the default arguments
of the evaluation function.}
}
\value{
If a new strategy is chosen, then the previous one is returned
(invisible), otherwise the current one is returned (visibly).
}
\description{
This function allows you to plan the future, more specifically,
it specifies how \code{\link{future}()}:s are resolved,
e.g. by eager or by lazy evaluation.
}
\details{
The default strategy is \code{\link{eager}}, which can be set by
option \option{future.plan} and, if that is not set,
system environment variable \env{R_FUTURE_PLAN}.
To reset the strategy back to the default, use \code{plan("default")}.
}
\examples{
a <- b <- c <- NA_real_

# A lazy future
plan(lazy)
f <- future({
  a <- 7
  b <- 3
  c <- 2
  a * b * c
})
y <- value(f)
print(y)
str(list(a=a, b=b, c=c)) ## All NAs


# An eager future
plan(eager)
f <- future({
  a <- 7
  b <- 3
  c <- 2
  a * b * c
})
y <- value(f)
print(y)
str(list(a=a, b=b, c=c)) ## All NAs


# A multicore future
plan(multicore)
f <- future({
  a <- 7
  b <- 3
  c <- 2
  a * b * c
})
y <- value(f)
print(y)
str(list(a=a, b=b, c=c)) ## All NAs


## Multisession futures gives an error on R CMD check on
## Windows (but not Linux or OS X) for unknown reasons.
## The same code works in package tests.
\donttest{

# A multisession future
plan(multisession)
f <- future({
  a <- 7
  b <- 3
  c <- 2
  a * b * c
})
y <- value(f)
print(y)
str(list(a=a, b=b, c=c)) ## All NAs

}
}
\seealso{
Evaluation functions provided by this package are \code{\link{eager}()},
\code{\link{lazy}()} and \code{\link{multicore}()}.
Other package may provide additional evaluation strategies/functions.
}

