% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callr.R
\name{callr}
\alias{callr}
\title{callr futures}
\usage{
callr(
  expr,
  envir = parent.frame(),
  substitute = TRUE,
  globals = TRUE,
  label = NULL,
  workers = availableCores(),
  ...
)
}
\arguments{
\item{expr}{The \R expression to be evaluated.}

\item{envir}{The environment in which global environment
should be located.}

\item{substitute}{Controls whether \code{expr} should be \code{substitute()}:d
or not.}

\item{globals}{(optional) a logical, a character vector, a named list, or
a \link[globals:Globals]{globals::Globals} object.  If \code{TRUE}, globals are identified by code
inspection based on \code{expr} and \code{tweak} searching from environment
\code{envir}.  If \code{FALSE}, no globals are used.  If a character vector, then
globals are identified by lookup based their names \code{globals} searching
from environment \code{envir}.  If a named list or a Globals object, the
globals are used as is.}

\item{label}{(optional) Label of the future.}

\item{workers}{The number of processes to be available for concurrent
callr futures.}

\item{\ldots}{Additional arguments passed to \code{CallrFuture()}.}
}
\value{
An object of class \link{CallrFuture}.
}
\description{
A callr future is an asynchronous multiprocess
future that will be evaluated in a background R session.
}
\details{
callr futures rely on the \pkg{callr} package, which is supported
on all operating systems.
}
