# WARNING - Generated by {fusen} from dev/flat_inflate_all_utils.Rmd: do not edit by hand

dummypackage <- tempfile("diag")
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- suppressMessages(add_minimal_package(pkg = dummypackage, overwrite = TRUE, open = FALSE))

# let's create 2 flat files
flat_file <- dev_file[grepl("flat_", dev_file)]
# flat_file2 <- gsub(x = flat_file, pattern = "flat_minimal.Rmd", replacement = "flat_minimal_2.Rmd")
# file.copy(from = flat_file, to = flat_file2, overwrite = TRUE)

flat_file2 <- fusen::add_additional(pkg = dummypackage, flat_name = "minimal_2", open = FALSE)

test_that("pre_inflate_all_diagnosis is a function", {
  expect_true(inherits(pre_inflate_all_diagnosis, "function"))
})

usethis::with_project(dummypackage, {
  # We inflate both flat files
  suppressMessages(
    inflate(
      pkg = dummypackage, flat_file = flat_file,
      vignette_name = "Get started", check = FALSE,
      open_vignette = FALSE
    )
  )

  suppressMessages(
    inflate(
      pkg = dummypackage, flat_file = flat_file2,
      vignette_name = "Get started2", check = FALSE,
      open_vignette = FALSE
    )
  )

  config_yml_ref <- yaml::read_yaml(file.path(dummypackage, "dev/config_fusen.yaml"))

  test_that("all files can be inflated with inflate_all()", {
    # all files can be inflated with inflate_all()
    config_yml <- config_yml_ref
    diag <- pre_inflate_all_diagnosis(config_yml = config_yml, pkg = dummypackage)


    diag_expected <- structure(
      list(
        flat = c("flat_minimal.Rmd", "flat_minimal_2.Rmd"),
        status = structure(
          c(
            "The flat file flat_minimal.Rmd is going to be inflated",
            "The flat file flat_minimal_2.Rmd is going to be inflated"
          ),
          class = c(
            "glue",
            "character"
          )
        ),
        type = c("cli::cli_alert_success", "cli::cli_alert_success"),
        params = c(NA, NA)
      ),
      row.names = c(NA, -2L),
      class = c("tbl_df", "tbl", "data.frame")
    )
    expect_equal(
      diag[order(diag$flat), ],
      diag_expected[order(diag_expected$flat), ]
    )
  })

  test_that("not inflated because 'inactive or deprecated' (message) works", {
    #  "not inflated because 'inactive or deprecated' (message) : a file is present in config_yml but its state is not 'active'
    config_yml <- config_yml_ref
    config_yml[["flat_minimal.Rmd"]][["state"]] <- "deprecated"
    diag <- pre_inflate_all_diagnosis(config_yml = config_yml, pkg = dummypackage)

    diag_expected <- structure(
      list(
        flat = c("flat_minimal.Rmd", "flat_minimal_2.Rmd"),
        status = structure(
          c(
            "The flat file flat_minimal.Rmd is not going to be inflated because it is in state 'inactive or deprecated'",
            "The flat file flat_minimal_2.Rmd is going to be inflated"
          ),
          class = c(
            "glue",
            "character"
          )
        ),
        type = c("cli::cli_alert_warning", "cli::cli_alert_success"),
        params = c(NA, NA)
      ),
      row.names = c(NA, -2L),
      class = c("tbl_df", "tbl", "data.frame")
    )

    expect_equal(
      diag[order(diag$flat), ],
      diag_expected[order(diag_expected$flat), ]
    )
  })

  test_that("not inflated because not in config file please inflate()  warning", {
    #  "not inflated because not in config file please inflate() from the flat once" (warning) : a file is missing from config_yml
    config_yml <- config_yml_ref
    config_yml[["flat_minimal.Rmd"]] <- NULL
    diag <- pre_inflate_all_diagnosis(config_yml = config_yml, pkg = dummypackage)

    diag_expected <- structure(
      list(
        flat = c("flat_minimal.Rmd", "flat_minimal_2.Rmd"),
        status = structure(
          c(
            "The flat file flat_minimal.Rmd is not going to be inflated. It was detected in your flats directory but it is absent from the config file.\nPlease inflate() it manually when you are ready, so that it is accounted the next time. Then you will be able to fully use `inflate_all*()`.",
            "The flat file flat_minimal_2.Rmd is going to be inflated"
          ),
          class = c(
            "glue",
            "character"
          )
        ),
        type = c("cli::cli_alert_danger", "cli::cli_alert_success"),
        params = c(NA, NA)
      ),
      row.names = c(NA, -2L),
      class = c("tbl_df", "tbl", "data.frame")
    )
    expect_equal(
      diag[order(diag$flat), ],
      diag_expected[order(diag_expected$flat), ]
    )
  })

  test_that("not inflated because in config but no state -  warning", {
    config_yml <- config_yml_ref
    config_yml[["flat_minimal.Rmd"]][["state"]] <- NULL
    diag <- pre_inflate_all_diagnosis(config_yml = config_yml, pkg = dummypackage)

    diag_expected <- structure(
      list(
        flat = c("flat_minimal.Rmd", "flat_minimal_2.Rmd"),
        status = structure(
          c(
            "The flat file flat_minimal.Rmd is not going to be inflated because there is no 'state' in the configuration file. \nPlease inflate() it manually once to get the full configuration file. Then you will be able to use `inflate_all*()` again.",
            "The flat file flat_minimal_2.Rmd is going to be inflated"
          ),
          class = c(
            "glue",
            "character"
          )
        ),
        type = c("cli::cli_alert_warning", "cli::cli_alert_success"),
        params = c(NA, NA)
      ),
      row.names = c(NA, -2L),
      class = c("tbl_df", "tbl", "data.frame")
    )
    expect_equal(
      diag[order(diag$flat), ],
      diag_expected[order(diag_expected$flat), ]
    )
  })

  test_that("not inflated because in config, but without parameters - stop", {
    #  "not inflated because in config, but without parameters, please inflate() again from the flat with this new 'fusen' version" (stop) : a file is is config_yml but has not inflate parameters
    config_yml <- config_yml_ref
    config_yml[["flat_minimal.Rmd"]][["inflate"]] <- NULL
    diag <- pre_inflate_all_diagnosis(config_yml = config_yml, pkg = dummypackage)

    diag_expected <- structure(
      list(
        flat = c("flat_minimal.Rmd", "flat_minimal_2.Rmd"),
        status = structure(
          c(
            "The flat file flat_minimal.Rmd is not going to be inflated because although present in the config file, it has no inflate() parameters. Please inflate() again from the flat file with this 'fusen' version. Then you will be able to use `inflate_all*()` again.",
            "The flat file flat_minimal_2.Rmd is going to be inflated"
          ),
          class = c(
            "glue",
            "character"
          )
        ),
        type = c("stop", "cli::cli_alert_success"),
        params = c("call. = FALSE", NA)
      ),
      row.names = c(NA, -2L),
      class = c("tbl_df", "tbl", "data.frame")
    )

    expect_equal(
      diag[order(diag$flat), ],
      diag_expected[order(diag_expected$flat), ]
    )
  })

  test_that("a file is in config.yml but missing", {
    # a file is in config.yml but missing from dev/
    config_yml <- config_yml_ref
    config_yml[["missing_file.Rmd"]] <- config_yml[["flat_minimal.Rmd"]]
    config_yml[["missing_file.Rmd"]][["path"]] <- "dev/missing_file.Rmd"
    diag <- pre_inflate_all_diagnosis(config_yml = config_yml, pkg = dummypackage)

    diag_expected <- structure(
      list(
        flat = c(
          "flat_minimal.Rmd", "flat_minimal_2.Rmd",
          "missing_file.Rmd"
        ),
        status = structure(
          c(
            "The flat file flat_minimal.Rmd is going to be inflated",
            "The flat file flat_minimal_2.Rmd is going to be inflated",
            "The file missing_file.Rmd is not going to be inflated because it was not found, have you changed the name or did you move in another place ? Maybe you want to set the state as 'state: deprecated' in the config file"
          ),
          class = c("glue", "character")
        ),
        type = c(
          "cli::cli_alert_success", "cli::cli_alert_success",
          "stop"
        ),
        params = c(NA, NA, "call. = FALSE")
      ),
      row.names = c(NA, -3L),
      class = c(
        "tbl_df", "tbl",
        "data.frame"
      )
    )

    expect_equal(
      diag[order(diag$flat), ],
      diag_expected[order(diag_expected$flat), ]
    )
  })

  test_that("messages show properly", {
    config_yml <- config_yml_ref
    config_yml[["missing_file.Rmd"]] <- config_yml[["flat_minimal.Rmd"]]
    config_yml[["missing_file.Rmd"]][["path"]] <- "dev/missing_file.Rmd"
    diag <- pre_inflate_all_diagnosis(config_yml = config_yml, pkg = dummypackage)

    expect_error(
      pre_inflate_all_diagnosis_eval(diag, type_stop = TRUE),
    )
    expect_message(
      pre_inflate_all_diagnosis_eval(diag, type_stop = FALSE),
    )
  })

  test_that("files listed in 'keep' are ignored", {
    config_yml <- config_yml_ref

    file.create(file.path(dummypackage, "R/zaza.R"))

    my_files_to_protect <- tibble::tribble(
      ~type, ~path,
      "R", "R/zaza.R"
    )

    df_to_config(my_files_to_protect, force = TRUE)

    config_yml <- yaml::read_yaml(file.path(dummypackage, "dev/config_fusen.yaml"))

    diag <- pre_inflate_all_diagnosis(config_yml = config_yml, pkg = dummypackage)

    expect_false(
      "keep" %in% diag[["flat"]]
    )
  })

  test_that("works if flat not named flat_", {
    # Rename and remove from config
    new_name <- file.path("dev", "test_minimal.Rmd")
    file.rename(file.path("dev", "flat_minimal.Rmd"), new_name)

    config_yml <- config_yml_ref
    config_yml[["flat_minimal.Rmd"]] <- NULL
    config_yml_file <- file.path(dummypackage, "dev/config_fusen.yaml")
    write_yaml_verbatim(config_yml, config_yml_file)

    # inflate again
    expect_error(
      suppressMessages(
        inflate(
          pkg = dummypackage, flat_file = new_name,
          vignette_name = "Get started", check = FALSE,
          open_vignette = FALSE,
          overwrite = TRUE
        )
      ),
      regexp = NA
    )


    config_yml <- yaml::read_yaml(file.path(dummypackage, "dev/config_fusen.yaml"))
    diag <- pre_inflate_all_diagnosis(config_yml = config_yml, pkg = dummypackage)

    diag_expected <- structure(
      list(
        flat = c(
          "test_minimal.Rmd", "flat_minimal_2.Rmd"
        ),
        status = structure(
          c(
            "The flat file test_minimal.Rmd is going to be inflated",
            "The flat file flat_minimal_2.Rmd is going to be inflated"
          ),
          class = c("glue", "character")
        ),
        type = c(
          "cli::cli_alert_success", "cli::cli_alert_success"
        ),
        params = c(NA, NA)
      ),
      row.names = c(NA, -2L),
      class = c(
        "tbl_df", "tbl",
        "data.frame"
      )
    )

    expect_equal(
      diag[order(diag$flat), ],
      diag_expected[order(diag_expected$flat), ]
    )
  })
  # At this stage, there is no more "dev/flat_minimal.Rmd", but a "dev/test_minimal.Rmd"
  file.rename(
    file.path(dummypackage, "dev", "test_minimal.Rmd"),
    file.path(dummypackage, "dev", "flat_minimal.Rmd")
  )

  # /!\ This one needs to be at the end because it deletes flat files
  test_that("all missing files gives stop messages without errors", {
    # error if we dont have any flat file in dev/
    config_yml <- config_yml_ref
    unlink(file.path(dummypackage, "dev/flat_minimal.Rmd"))
    unlink(file.path(dummypackage, "dev/flat_minimal_2.Rmd"))

    diag <- pre_inflate_all_diagnosis(config_yml = config_yml, pkg = dummypackage)

    diag_expected <- structure(
      list(
        flat = c(
          "flat_minimal.Rmd", "flat_minimal_2.Rmd"
        ),
        status = structure(
          c(
            "The file flat_minimal.Rmd is not going to be inflated because it was not found, have you changed the name or did you move in another place ? Maybe you want to set the state as 'state: deprecated' in the config file",
            "The file flat_minimal_2.Rmd is not going to be inflated because it was not found, have you changed the name or did you move in another place ? Maybe you want to set the state as 'state: deprecated' in the config file"
          ),
          class = c("glue", "character")
        ),
        type = c(
          "stop", "stop"
        ),
        params = c("call. = FALSE", "call. = FALSE")
      ),
      row.names = c(NA, -2L),
      class = c(
        "tbl_df", "tbl",
        "data.frame"
      )
    )

    expect_equal(
      diag[order(diag$flat), ],
      diag_expected[order(diag_expected$flat), ]
    )
  })

  # /!\ This one needs to be at the end because it deletes flat files
  test_that("all missing files and config empty gives stops", {
    config_yml <- list(keep = list(path = "keep"))
    expect_error(
      diag <- pre_inflate_all_diagnosis(config_yml = config_yml, pkg = dummypackage),
      regexp = "There are no flat files listed in config or files starting with 'flat_' in the 'dev/' directory"
    )
  })
})

unlink(dummypackage, recursive = TRUE)

dummypackage <- tempfile("readinflateparams")
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- suppressMessages(add_minimal_package(pkg = dummypackage, overwrite = TRUE, open = FALSE))

# let's create 2 flat files
flat_file <- dev_file[grepl("flat_", dev_file)]
flat_file2 <- gsub(x = flat_file, pattern = "flat_minimal.Rmd", replacement = "flat_minimal_2.Rmd")
file.copy(from = flat_file, to = flat_file2, overwrite = TRUE)

test_that("read_inflate_params is a function", {
  expect_true(inherits(read_inflate_params, "function"))
})

test_that("read_inflate_params doesnt work if config fusen does not exist", {
  config_fusen_not_existing <-
    system.file("inflate_all/fake.yaml", package = "fusen")
  expect_error(read_inflate_params(config_yml = config_fusen_not_existing))
})



usethis::with_project(dummypackage, {
  # We inflate both flat files
  suppressMessages(
    inflate(
      pkg = dummypackage, flat_file = flat_file,
      vignette_name = "Get started", check = FALSE,
      open_vignette = FALSE
    )
  )

  suppressMessages(
    inflate(
      pkg = dummypackage, flat_file = flat_file2,
      vignette_name = "Get started2", check = FALSE,
      open_vignette = FALSE
    )
  )

  config_yml_ref <- yaml::read_yaml(file.path(dummypackage, "dev/config_fusen.yaml"))

  test_that("read_inflate_params work properly", {
    inflate_params <-
      read_inflate_params(config_yml = config_yml_ref)

    expect_equal(
      length(inflate_params),
      2
    )

    expect_true(
      all(names(inflate_params) %in% c("flat_minimal_2.Rmd", "flat_minimal.Rmd"))
    )

    expect_equal(
      inflate_params[["flat_minimal.Rmd"]],
      list(
        flat_file = "dev/flat_minimal.Rmd",
        vignette_name = "Get started",
        open_vignette = FALSE,
        check = FALSE,
        document = TRUE,
        overwrite = "ask"
      )
    )

    expect_equal(
      inflate_params[["flat_minimal_2.Rmd"]],
      list(
        flat_file = "dev/flat_minimal_2.Rmd",
        vignette_name = "Get started2",
        open_vignette = FALSE,
        check = FALSE,
        document = TRUE,
        overwrite = "ask"
      )
    )
  })

  # what happens if we deprecate a file
  test_that("read_inflate_params work properly with deprecated", {
    config_yml_ref[["flat_minimal.Rmd"]][["state"]] <- "deprecated"

    inflate_params <-
      read_inflate_params(config_yml = config_yml_ref)

    expect_null(inflate_params[["flat_minimal.Rmd"]])

    expect_equal(
      length(inflate_params),
      1
    )
  })

  # what happens if we add a file in the "keep" section
  test_that("read_inflate_params work properly with keep section", {
    file.create(file.path(dummypackage, "R/zaza.R"))

    my_files_to_protect <- tibble::tribble(
      ~type, ~path,
      "R", "R/zaza.R"
    )

    df_to_config(my_files_to_protect, force = TRUE)

    config_yml <-
      yaml::read_yaml(file.path(dummypackage, "dev/config_fusen.yaml"))

    inflate_params <-
      read_inflate_params(config_yml = config_yml)

    expect_false("keep" %in% names(inflate_params))

    # Old version with no state for "keep" section should work too
    config_yml[["keep"]][["state"]] <- NULL

    expect_error(
      inflate_params <-
        read_inflate_params(config_yml = config_yml),
      regexp = NA
    )

    expect_false("keep" %in% names(inflate_params))
  })
})

unlink(dummypackage, recursive = TRUE)
