% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainData.R
\name{TrainData}
\alias{TrainData}
\title{TrainData Class}
\description{
This class implements the training data. A \link{TrainData} object can only
exist as a component of a \link{TrainLayer} or a \link{TrainMetaLayer} object.
}
\seealso{
\link{TrainLayer}, \link{Lrner}, \link{Model}, \link{TestData}
}
\section{Super class}{
\code{\link[fuseMLR:Data]{fuseMLR::Data}} -> \code{TrainData}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TrainData-new}{\code{TrainData$new()}}
\item \href{#method-TrainData-print}{\code{TrainData$print()}}
\item \href{#method-TrainData-summary}{\code{TrainData$summary()}}
\item \href{#method-TrainData-getData}{\code{TrainData$getData()}}
\item \href{#method-TrainData-getTargetValues}{\code{TrainData$getTargetValues()}}
\item \href{#method-TrainData-getTargetName}{\code{TrainData$getTargetName()}}
\item \href{#method-TrainData-getTrainLayer}{\code{TrainData$getTrainLayer()}}
\item \href{#method-TrainData-getTestLayer}{\code{TrainData$getTestLayer()}}
\item \href{#method-TrainData-setDataFrame}{\code{TrainData$setDataFrame()}}
\item \href{#method-TrainData-clone}{\code{TrainData$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getCompleteData"><a href='../../fuseMLR/html/Data.html#method-Data-getCompleteData'><code>fuseMLR::Data$getCompleteData()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getDataFrame"><a href='../../fuseMLR/html/Data.html#method-Data-getDataFrame'><code>fuseMLR::Data$getDataFrame()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getId"><a href='../../fuseMLR/html/Data.html#method-Data-getId'><code>fuseMLR::Data$getId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getIndCol"><a href='../../fuseMLR/html/Data.html#method-Data-getIndCol'><code>fuseMLR::Data$getIndCol()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getIndSubset"><a href='../../fuseMLR/html/Data.html#method-Data-getIndSubset'><code>fuseMLR::Data$getIndSubset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getSetDiff"><a href='../../fuseMLR/html/Data.html#method-Data-getSetDiff'><code>fuseMLR::Data$getSetDiff()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getVarSubset"><a href='../../fuseMLR/html/Data.html#method-Data-getVarSubset'><code>fuseMLR::Data$getVarSubset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="impute"><a href='../../fuseMLR/html/Data.html#method-Data-impute'><code>fuseMLR::Data$impute()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainData-new"></a>}}
\if{latex}{\out{\hypertarget{method-TrainData-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new object from the current class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainData$new(id, data_frame, train_layer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr
The Object ID.}

\item{\code{data_frame}}{\code{data.frame}\cr
\code{data.frame} containing data.}

\item{\code{train_layer}}{\code{TrainLayer} \cr
Training layer where to store the current object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainData-print"></a>}}
\if{latex}{\out{\hypertarget{method-TrainData-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainData$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainData-summary"></a>}}
\if{latex}{\out{\hypertarget{method-TrainData-summary}{}}}
\subsection{Method \code{summary()}}{
Summary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainData$summary(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainData-getData"></a>}}
\if{latex}{\out{\hypertarget{method-TrainData-getData}{}}}
\subsection{Method \code{getData()}}{
Getter of the current \code{data.frame} wihtout individual
ID nor target variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainData$getData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{data.frame} without individual ID nor target variables is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainData-getTargetValues"></a>}}
\if{latex}{\out{\hypertarget{method-TrainData-getTargetValues}{}}}
\subsection{Method \code{getTargetValues()}}{
Getter of target values stored on the current training layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainData$getTargetValues()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The observed target values stored on the current training layer are returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainData-getTargetName"></a>}}
\if{latex}{\out{\hypertarget{method-TrainData-getTargetName}{}}}
\subsection{Method \code{getTargetName()}}{
Getter of the target variable name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainData$getTargetName()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainData-getTrainLayer"></a>}}
\if{latex}{\out{\hypertarget{method-TrainData-getTrainLayer}{}}}
\subsection{Method \code{getTrainLayer()}}{
Getter of the current training layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainData$getTrainLayer()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The training layer (from class \link{TrainLayer}) on which the current train data are stored
is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainData-getTestLayer"></a>}}
\if{latex}{\out{\hypertarget{method-TrainData-getTestLayer}{}}}
\subsection{Method \code{getTestLayer()}}{
Getter of the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainData$getTestLayer()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The layer (from class \link{TestLayer}) on which the current train data are stored
is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainData-setDataFrame"></a>}}
\if{latex}{\out{\hypertarget{method-TrainData-setDataFrame}{}}}
\subsection{Method \code{setDataFrame()}}{
Set a new \code{data.frame} to the current object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainData$setDataFrame(data_frame)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_frame}}{\code{data.frame}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The current object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainData-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TrainData-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainData$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
