% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future-invoke-map.R
\name{future_invoke_map}
\alias{future_invoke_map}
\alias{future_invoke_map_chr}
\alias{future_invoke_map_dbl}
\alias{future_invoke_map_int}
\alias{future_invoke_map_lgl}
\alias{future_invoke_map_raw}
\alias{future_invoke_map_dfr}
\alias{future_invoke_map_dfc}
\title{Invoke functions via futures}
\usage{
future_invoke_map(
  .f,
  .x = list(NULL),
  ...,
  .env = NULL,
  .options = furrr_options(),
  .env_globals = parent.frame(),
  .progress = FALSE
)

future_invoke_map_chr(
  .f,
  .x = list(NULL),
  ...,
  .env = NULL,
  .options = furrr_options(),
  .env_globals = parent.frame(),
  .progress = FALSE
)

future_invoke_map_dbl(
  .f,
  .x = list(NULL),
  ...,
  .env = NULL,
  .options = furrr_options(),
  .env_globals = parent.frame(),
  .progress = FALSE
)

future_invoke_map_int(
  .f,
  .x = list(NULL),
  ...,
  .env = NULL,
  .options = furrr_options(),
  .env_globals = parent.frame(),
  .progress = FALSE
)

future_invoke_map_lgl(
  .f,
  .x = list(NULL),
  ...,
  .env = NULL,
  .options = furrr_options(),
  .env_globals = parent.frame(),
  .progress = FALSE
)

future_invoke_map_raw(
  .f,
  .x = list(NULL),
  ...,
  .env = NULL,
  .options = furrr_options(),
  .env_globals = parent.frame(),
  .progress = FALSE
)

future_invoke_map_dfr(
  .f,
  .x = list(NULL),
  ...,
  .env = NULL,
  .options = furrr_options(),
  .env_globals = parent.frame(),
  .progress = FALSE
)

future_invoke_map_dfc(
  .f,
  .x = list(NULL),
  ...,
  .env = NULL,
  .options = furrr_options(),
  .env_globals = parent.frame(),
  .progress = FALSE
)
}
\arguments{
\item{.f}{A list of functions.}

\item{.x}{A list of argument-lists the same length as \code{.f} (or length 1). The
default argument, \code{list(NULL)}, will be recycled to the same length as
\code{.f}, and will call each function with no arguments (apart from any
supplied in \code{...}).}

\item{...}{Additional arguments passed to each function.}

\item{.env}{Environment in which \code{\link[=do.call]{do.call()}} should
evaluate a constructed expression. This only matters if you pass
as \code{.f} the name of a function rather than its value, or as
\code{.x} symbols of objects rather than their values.}

\item{.options}{The \code{future} specific options to use with the workers. This
must be the result from a call to \code{\link[=furrr_options]{furrr_options()}}.}

\item{.env_globals}{The environment to look for globals required by \code{.x} and
\code{...}. Globals required by \code{.f} are looked up in the function environment
of \code{.f}.}

\item{.progress}{A single logical. Should a progress bar be displayed?
Only works with multisession, multicore, and multiprocess futures. Note
that if a multicore/multisession future falls back to sequential, then
a progress bar will not be displayed.

\strong{Warning:} The \code{.progress} argument will be deprecated and removed
in a future version of furrr in favor of using the more robust
\href{https://CRAN.R-project.org/package=progressr}{progressr}
package.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

These functions work exactly the same as \code{\link[purrr:invoke]{purrr::invoke_map()}} functions, but
allow you to invoke in parallel.
}
\examples{
\donttest{plan(multisession, workers = 2)}

df <- dplyr::tibble(
  f = c("runif", "rpois", "rnorm"),
  params = list(
    list(n = 10),
    list(n = 5, lambda = 10),
    list(n = 10, mean = -3, sd = 10)
  )
)

future_invoke_map(df$f, df$params, .options = furrr_options(seed = 123))

\dontshow{
# Close open connections for R CMD Check
if (!inherits(plan(), "sequential")) plan(sequential)
}
}
