% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fclust.R
\name{plot_motifs_histo}
\alias{plot_motifs_histo}
\title{Plot histogram of assemblage performances by assembly motif}
\usage{
plot_motifs_histo(fobs, assMotif,
                  nbar    = 0,
                  main     = "",
                  opt.mean = "amean")
}
\arguments{
\item{fobs}{numeric vector.
The vector contains observed assemblage performances.}

\item{assMotif}{an integer vector of \code{length(fobs)}.
The vector contains the labels of each assemblages.
The labels are only used to plot the assemblage performances
that share a same assembly motif
with a same symbol and color.}

\item{nbar}{an integer.
It is the number of wished bars of histogram.}

\item{main}{a string. The string is used as graph title.}

\item{opt.mean}{a character equals to \code{"amean"} or \code{"gmean"}.
Switch to arithmetic formula if \code{opt.mean = "amean"}.
Switch to geometric formula if \code{opt.mean = "gmean"}.}
}
\value{
Nothing. It is a procedure.
}
\description{
Plot the histogram of performances of all assemblage,
and the density curves of performances sorted by assembly motif
}
\details{
A colour is assigned to each assembl motif.
The density curve of each assembly motif
and its mean are plotted.
The location of each observation is reported on the graph bottom.
}
\keyword{internal}
