#' Air quality data
#'
#' @description
#' This data set has been included from the R package
#' \href{https://github.com/cran/FRegSigCom/}{\code{FRegSigCom}}.
#' The original .RData file is available at
#' \href{https://github.com/cran/FRegSigCom/blob/master/data/air.RData}{
#' https://github.com/cran/FRegSigCom/blob/master/data/air.RData}.
#'
#' Data collected hourly in 355 days (days with missing values removed)
#' in a significantly polluted area within an Italian city.
#'
#' @usage data("air")
#'
#' @format A list of 7 matrices with 355 rows and 24 columns:
#' \describe{
#'   \item{NO2}{Hourly observation of concentration level of NO2 in 355 days}
#'   \item{CO}{Hourly observation of concentration level of CO in 355 days}
#'   \item{NMHC}{Hourly observation of concentration level of NMHC in 355 days}
#'   \item{NOx}{Hourly observation of concentration level of NOx in 355 days}
#'   \item{C6H6}{Hourly observation of concentration level of C6H6 in 355 days}
#'   \item{temperature}{Hourly observation of concentration
#'   level of temperature in 355 days}
#'   \item{humidity}{Hourly observation of concentration
#'   level of humidity in 355 days}
#' }
#' @source \url{https://archive.ics.uci.edu/ml/datasets/Air+quality}
#'
#' @references
#' De Vito, S., Massera E., Piga M., Martinotto L. and Di Francia G. (2008).
#' On field calibration of an electronic nose for
#' benzene estimation in an urban pollution monitoring scenario
#' \emph{Sensors and Actuators B: Chemical}, 129: 50-757.
#' <doi:10.1016/j.snb.2007.09.060>
#'
#' Xin Qi and Ruiyan Luo (2019).
#' Nonlinear function on function
#' additive model with multiple predictor curves.
#' \emph{Statistica Sinica}, 29:719-739.
#' <doi:10.5705/ss.202017.0249>
"air"
