% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_recommended_path.R
\name{find_recommended_path}
\alias{find_recommended_path}
\title{Find Recommended Path in a Tree Structure}
\usage{
find_recommended_path(minidend, window_data, min_card)
}
\arguments{
\item{minidend}{A tree structure representing the hierarchy of nodes, 
from which leaves will be derived for analysis.}

\item{window_data}{A matrix or data frame containing data associated with each node.}

\item{min_card}{An integer specifying the minimum number of leaves that must be present in a node 
for it to be considered for recommendation.}
}
\value{
A list containing:
        - \code{seed_path_info}: A data frame summarizing the valid seed nodes, their number of leaves, 
        heights, and recommended nodes.
        - \code{seed_path_list}: A list containing the names of elements for each node in the seed path.
        - \code{score_path_list}: A list of scores adjusted for each node in the seed path.
        - \code{recommended_node_labels}: A list of labels for the recommended nodes.
        - \code{recommended_node_scores}: A numeric vector containing scores for the recommended nodes.
}
\description{
This function identifies a recommended path in a tree structure based on user-defined minimum criteria. 
It filters nodes based on the number of leaves and calculates scores for potential recommendations.
}
\details{
The function follows these steps:
1. Extracts the leaves and heights of each node in the tree.
2. Filters nodes based on the minimum number of leaves specified by \code{min_card}.
3. Identifies nodes that are parents of the filtered nodes, marking them for deletion.
4. For each seed node, calculates crossing points with other seed nodes.
5. Calculates adjusted scores for nodes in the seed path using the C++ function \code{fMSR_adj}.
6. Recommends nodes based on calculated scores and returns a summary of results.
}
