% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kGAAComposition.R
\name{kGAAComposition}
\alias{kGAAComposition}
\title{K Grouped Amino Acid Composition}
\usage{
kGAAComposition(
  seqs,
  rng = 3,
  upto = FALSE,
  normalized = TRUE,
  Grp = "locFus",
  label = c()
)
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{rng}{This parameter can be a number or a vector. Each entry of the vector holds the value of k in the k-mer composition.
For each k in the rng vector, a new vector (whose size is 20^k) is created which contains the frequency of k-mers.}

\item{upto}{It is a logical parameter. The default value is FALSE. If rng is a number and upto is set to TRUE, rng is converted
to a vector with values from 1 to rng.}

\item{normalized}{is a logical parameter. When it is FALSE, the return value of the function does not change. Otherwise, the return value is normalized using the length of the sequence.}

\item{Grp}{is a list of vectors containig amino acids. Each vector represents a category. Users can define a customized amino acid grouping, provided that the sum of all amino acids is 20 and there is no repeated amino acid in the groups.
Also, users can choose 'cTriad'(conjointTriad), 'locFus', or 'aromatic'. Each option provides specific information about the type of an amino acid grouping.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns is ((number of categorizes)^k)*(length of rng vector).
}
\description{
In this function, amino acids are first grouped into user-defined categories.
Later, the composition of the k grouped amino acids is computed.
Please note that this function differs from \link{kAAComposition} which works on individual amino acids.
}
\details{
for more details, please refer to \link{kAAComposition}
}
\examples{
filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
mat1<-CkSGAApair(seqs=filePrs,rng=2,upto=TRUE,Grp="aromatic")

mat2<-CkSGAApair(seqs=filePrs,rng=c(1,3,5),Grp=
list(Grp1=c("G","A","V","L","M","I","F","Y","W"),Grp2=c("K","R","H","D","E")
,Grp3=c("S","T","C","P","N","Q")))
}
