% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NUCKpartComposition.R
\name{NUCKpartComposition}
\alias{NUCKpartComposition}
\title{Nucleotide to K Part Composition}
\usage{
NUCKpartComposition(
  seqs,
  k = 5,
  ORF = FALSE,
  reverseORF = TRUE,
  normalized = TRUE,
  label = c()
)
}
\arguments{
\item{seqs}{is a FASTA file containing nucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a nucleotide sequence.}

\item{k}{is an integer value. Each sequence should be divided to k partition(s).}

\item{ORF}{(Open Reading Frame) is a logical parameter. If it is set to true, ORF region of each sequence is considered instead of the original sequence (i.e., 3-frame).}

\item{reverseORF}{is a logical parameter. It is enabled only if ORF is true.
If reverseORF is true, ORF region will be searched in the sequence and also in the reverse complement of the sequence (i.e., 6-frame).}

\item{normalized}{is a logical parameter. When it is FALSE, the return value of the function does not change. Otherwise, the return value is normalized using the length of the sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
a feature matrix with k*4 number of columns. The number of rows is equal to the number of
sequences.
}
\description{
In this function, each sequence is divided into k equal partitions.
The length of each part is equal to ceiling(l(lenght of the sequence)/k).
The last part can have a different length containing the residual nucleotides.
The nucleotide composition is calculated for each part.
}
\note{
Warning: The length of all sequences should be greater than k.
}
\examples{

fileLNC<-system.file("extdata/Athaliana_LNCRNA.fa",package="ftrCOOL")
mat<-NUCKpartComposition(seqs=fileLNC,k=5,ORF=TRUE,reverseORF=FALSE,normalized=FALSE)
}
