% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_io.R
\name{read.md.demographics}
\alias{read.md.demographics}
\title{Read demographics file}
\usage{
read.md.demographics(demographics_file, column_names, header = TRUE,
  scale_and_center = FALSE, sep = "", report = TRUE,
  stringsAsFactors = TRUE)
}
\arguments{
\item{demographics_file, }{string. The path to the file.}

\item{column_names, }{vector of strings. The column names to set in the returned dataframe. The length must match the number of columns in the file.}

\item{header, }{logical. Whether the file starts with a header line.}

\item{scale_and_center, }{logical. Whether to center and scale the data. Defaults to FALSE.}

\item{sep, }{string. Separator passed to utils::read.table(), defaults to tabulator.}

\item{report, }{logical. Whether to write an overview, i.e., some descriptive statistics for each column, to STDOUT. Defaults to TRUE.}

\item{stringsAsFactors, }{logical. Whether to convert strings in the input data to factors. Defaults to TRUE.}
}
\value{
a dataframe. The data in the file. String columns will be returned as factors, which you may want to adapt afterwards for the subject identifier column.
}
\description{
Load a list of subjects and metadata from a demographics file, i.e., a tab-separated file containing an arbitrary number of columns, one of which must be the subject id.
}
\examples{
   demographics_file =
   system.file("extdata", "demographics.tsv", package = "fsbrain", mustWork = TRUE);
   column_names = c("subject_id", "group", "age");
   demographics = read.md.demographics(demographics_file,
   column_names = column_names, report = FALSE);

}
\seealso{
Other metdata functions: \code{\link{read.md.subjects}}
}
\concept{metdata functions}
