% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_files_current.R
\name{is_files_current}
\alias{is_files_current}
\title{Check Whether Files are Current}
\usage{
is_files_current(
  ...,
  newer_than = 1,
  units = "week",
  within = 1,
  within_units = "days"
)
}
\arguments{
\item{...}{File paths.}

\item{newer_than}{The number of \bold{units} the files need to be newer than.}

\item{units}{The unit of \bold{newer_than}. See \code{\link{difftime}}.}

\item{within}{The number of \bold{units} the files need to be modified
within.}

\item{within_units}{The unit of \bold{within}. See \code{\link{difftime}}.}
}
\value{
\code{\link[base:TRUE]{TRUE}} on success, 
\code{\link[base:FALSE]{FALSE}} otherwise.
}
\description{
I sometimes produce a couple of files by some kind of process and need to
check whether they are fairly current and probably product of the same run.
So I need to know whether a bunch of files was modified within the
last, say, 7 days \emph{and} that their modification dates do not differ by
more than, say, 24 hours.
}
\examples{
p1 <- tempfile()
p2 <- tempfile()
p3 <- tempfile()
touch(p1)
touch(p2)
Sys.sleep(3)
touch(p3)
is_files_current(p3, newer_than = 1, units = "days",
                 within = 4, within_units = "secs")
is_files_current(p1, p2, p3, newer_than = 1, units = "days",
                 within = 4, within_units = "secs")
is_files_current(p1, p2, p3, newer_than = 1, units = "days",
                 within = 1, within_units = "secs")
is_files_current(p1, p2, p3, newer_than = 1, units = "secs",
                 within = 4, within_units = "secs")
}
