% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.R
\name{freq}
\alias{freq}
\title{Freq}
\usage{
freq(x, file = NULL, weight = NULL, maxrow = 30, type = "html",
  template = NULL)
}
\arguments{
\item{x}{Input data. Can be a dataframe, list or vector.}

\item{file}{File name. Optional file name to save the output.}

\item{weight}{Weight variable name. (Note: this is a placeholder and not currently implemented)}

\item{maxrow}{Maximum number of rows to display in each frequency table.}

\item{type}{Output type. Either html or doc.}

\item{template}{Word template. Optional doc template to use if producing doc output.}
}
\value{
A frequency table in html or doc format.
}
\description{
This function generates frequency tables
}
\examples{

# Suppress external output for examples
options(frequency_render = FALSE)

# Create frequency tables for the entire dataset
freq(big5)

# For specific variable/s
freq(big5[5:6])
freq(big5$country)

# Produce a list of tables
out <- freq(big5[8:10])
out[1]

options(frequency_render = TRUE)
\dontrun{
# To automatically open html output in your browser use the following option:
options(frequency_open_output = TRUE)
freq(big5[, c('gender', 'E1')])

# To save the output specify the filename and format
freq(big5, file = "mydir/myfile.html")

# Supports label attributes from the package foreign package
library(foreign)
dat <- read.spss(myfile)
freq(dat)
# (Note: foreign may drop attributes when using to.data.frame = TRUE)
df <- read.spss(myfile, to.data.frame = TRUE)
freq(df)

# Also supports label attributes from the haven package
library(haven)
dat <- read_sav(myfile)
freq(dat)

# as well as other data with no label attributes
dat <- data.frame(id = 1:3, val = letters[1:3])
freq(dat)

}

}
